/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.admin.cli;

import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-timers")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.timers")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-timers", description="List Timers")})
public class ListTimers
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ListTimers.class);
    @Param(primary=true, optional=true, defaultValue="server")
    String target;
    @Inject
    private EjbContainerUtil ejbContainerUtil;
    @Inject
    Target targetUtil;

    @Override
    public void execute(AdminCommandContext context) {
        int i;
        ActionReport report = context.getActionReport();
        String[] serverIds = null;
        if (this.targetUtil.isCluster(this.target)) {
            List<Server> serversInCluster = this.targetUtil.getInstances(this.target);
            serverIds = new String[serversInCluster.size()];
            for (i = 0; i < serverIds.length; ++i) {
                serverIds[i] = serversInCluster.get(i).getName();
            }
        } else {
            serverIds = new String[]{this.target};
        }
        try {
            String[] timerCounts = this.listTimers(serverIds);
            for (i = 0; i < serverIds.length; ++i) {
                ActionReport.MessagePart part = report.getTopMessagePart().addChild();
                part.setMessage(serverIds[i] + ": " + timerCounts[i]);
            }
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("list.timers.failed", "List Timers command failed"));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
        }
    }

    private String[] listTimers(String[] serverIds) {
        String[] result = new String[serverIds.length];
        if (EJBTimerService.isEJBTimerServiceLoaded()) {
            EJBTimerService ejbTimerService = EJBTimerService.getEJBTimerService();
            if (ejbTimerService != null) {
                result = ejbTimerService.listTimers(serverIds);
            }
        } else {
            for (int i = 0; i < serverIds.length; ++i) {
                result[i] = "0";
            }
        }
        return result;
    }
}

