/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.deployment.util;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebService;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferencer;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.deployment.util.EjbBundleVisitor;
import com.sun.enterprise.deployment.util.TracerVisitor;
import java.util.Collection;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.ContainerTransaction;
import org.glassfish.ejb.deployment.descriptor.EjbBundleDescriptorImpl;
import org.glassfish.ejb.deployment.descriptor.EjbCMPEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.FieldDescriptor;
import org.glassfish.ejb.deployment.descriptor.PersistenceDescriptor;
import org.glassfish.ejb.deployment.descriptor.QueryDescriptor;
import org.glassfish.ejb.deployment.descriptor.RelationshipDescriptor;

public class EjbBundleTracerVisitor
extends TracerVisitor
implements EjbBundleVisitor {
    @Override
    public void accept(BundleDescriptor descriptor) {
        if (descriptor instanceof EjbBundleDescriptorImpl) {
            EjbBundleDescriptorImpl ejbBundle = (EjbBundleDescriptorImpl)descriptor;
            this.accept(ejbBundle);
            for (EjbDescriptor anEjb : ejbBundle.getEjbs()) {
                anEjb.visit(this.getSubDescriptorVisitor(anEjb));
            }
            if (ejbBundle.hasRelationships()) {
                for (RelationshipDescriptor rd : ejbBundle.getRelationships()) {
                    this.accept(rd);
                }
            }
            for (WebService ws : ejbBundle.getWebServices().getWebServices()) {
                this.accept(ws);
            }
        }
        super.accept(descriptor);
    }

    @Override
    public void accept(EjbBundleDescriptor ebd) {
        this.logInfo("Ejb Bundle " + ebd.getName());
    }

    protected void accept(EjbDescriptor ejb) {
        Object msgDestReferencer;
        Set methods;
        this.logInfo("==================");
        this.logInfo(ejb.getType() + " Bean " + ejb.getName());
        this.logInfo("\thomeClassName " + ejb.getHomeClassName());
        this.logInfo("\tremoteClassName " + ejb.getRemoteClassName());
        this.logInfo("\tlocalhomeClassName " + ejb.getLocalHomeClassName());
        this.logInfo("\tlocalClassName " + ejb.getLocalClassName());
        this.logInfo("\tremoteBusinessIntfs " + ejb.getRemoteBusinessClassNames());
        this.logInfo("\tlocalBusinessIntfs " + ejb.getLocalBusinessClassNames());
        this.logInfo("\tjndiName " + ejb.getJndiName());
        this.logInfo("\tejbClassName " + ejb.getEjbClassName());
        this.logInfo("\ttransactionType " + ejb.getTransactionType());
        if (!ejb.getUsesCallerIdentity().booleanValue()) {
            this.logInfo("\trun-as role " + ejb.getRunAsIdentity());
        } else {
            this.logInfo("\tuse-caller-identity " + ejb.getUsesCallerIdentity());
        }
        for (EjbReference ejbReference : ejb.getEjbReferenceDescriptors()) {
            this.accept(ejbReference);
        }
        for (MethodPermission methodPermission : ejb.getPermissionedMethodsByPermission().keySet()) {
            methods = (Set)ejb.getPermissionedMethodsByPermission().get(methodPermission);
            this.accept(methodPermission, methods);
        }
        if (ejb.getStyledPermissionedMethodsByPermission() != null) {
            for (MethodPermission methodPermission : ejb.getStyledPermissionedMethodsByPermission().keySet()) {
                methods = (Set)ejb.getStyledPermissionedMethodsByPermission().get(methodPermission);
                this.accept(methodPermission, methods);
            }
        }
        for (RoleReference roleReference : ejb.getRoleReferences()) {
            this.accept(roleReference);
        }
        for (MethodDescriptor methodDescriptor : ejb.getMethodContainerTransactions().keySet()) {
            ContainerTransaction ct = (ContainerTransaction)ejb.getMethodContainerTransactions().get(methodDescriptor);
            this.accept(methodDescriptor, ct);
        }
        for (EnvironmentProperty environmentProperty : ejb.getEnvironmentProperties()) {
            this.accept(environmentProperty);
        }
        for (ResourceReferenceDescriptor resourceReferenceDescriptor : ejb.getResourceReferenceDescriptors()) {
            this.accept(resourceReferenceDescriptor);
        }
        for (ResourceEnvReferenceDescriptor resourceEnvReferenceDescriptor : ejb.getResourceEnvReferenceDescriptors()) {
            this.accept(resourceEnvReferenceDescriptor);
        }
        for (MessageDestinationReferencer messageDestinationReferencer : ejb.getMessageDestinationReferenceDescriptors()) {
            this.accept(messageDestinationReferencer);
        }
        if (ejb.getType().equals("Message-driven") && (msgDestReferencer = (MessageDestinationReferencer)((Object)ejb)).getMessageDestinationLinkName() != null) {
            this.accept((MessageDestinationReferencer)msgDestReferencer);
        }
        for (ServiceReferenceDescriptor serviceReferenceDescriptor : ejb.getServiceReferenceDescriptors()) {
            this.accept(serviceReferenceDescriptor);
        }
        if (ejb instanceof EjbCMPEntityDescriptor) {
            EjbCMPEntityDescriptor cmp = (EjbCMPEntityDescriptor)ejb;
            PersistenceDescriptor persistenceDescriptor = cmp.getPersistenceDescriptor();
            for (FieldDescriptor fd : persistenceDescriptor.getCMPFields()) {
                this.accept(fd);
            }
            for (FieldDescriptor o : persistenceDescriptor.getQueriedMethods()) {
                if (!(o instanceof MethodDescriptor)) continue;
                QueryDescriptor qd = persistenceDescriptor.getQueryFor((MethodDescriptor)((Object)o));
                this.accept(qd);
            }
        }
    }

    protected void accept(MethodPermission pm, Collection<MethodDescriptor> mds) {
        this.logInfo("For method permission : " + pm.toString());
        for (MethodDescriptor md : mds) {
            this.logInfo("\t" + md.prettyPrint());
        }
    }

    protected void accept(RoleReference rr) {
        this.logInfo("Security Role Reference : " + rr.getName() + " link " + rr.getValue());
    }

    protected void accept(MethodDescriptor md, ContainerTransaction ct) {
        this.logInfo(ct.getTransactionAttribute() + " Container Transaction for method " + md.prettyPrint());
    }

    protected void accept(FieldDescriptor fd) {
        this.logInfo("CMP Field " + fd);
    }

    protected void accept(QueryDescriptor qd) {
        this.logInfo(qd.toString());
    }

    protected void accept(RelationshipDescriptor rd) {
        this.logInfo("============ Relationships ===========");
        this.logInfo("From EJB " + rd.getSource().getName() + " cmr field : " + rd.getSource().getCMRField() + "(" + rd.getSource().getCMRFieldType() + ")  to EJB " + rd.getSink().getName() + " isMany " + rd.getSource().getIsMany() + " cascade-delete " + rd.getSource().getCascadeDelete());
        this.logInfo("To  EJB " + rd.getSink().getName() + " isMany " + rd.getSink().getIsMany() + " cascade-delete " + rd.getSink().getCascadeDelete());
        if (rd.getIsBidirectional()) {
            this.logInfo("Bidirectional cmr field : " + rd.getSink().getCMRField() + "(" + rd.getSink().getCMRFieldType() + ")");
        }
    }

    private void logInfo(String message) {
        DOLUtils.getDefaultLogger().info(message);
    }
}

