/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ejb.security.application;

import com.sun.ejb.EjbInvocation;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.invocation.RegisteredComponentInvocationHandler;
import org.jvnet.hk2.annotations.Service;

@Service(name="ejbSecurityCIH")
@Singleton
public class EjbSecurityComponentInvocationHandler
implements RegisteredComponentInvocationHandler {
    private static final Logger _logger = LogDomains.getLogger(EjbSecurityComponentInvocationHandler.class, "javax.enterprise.system.container.ejb");
    @Inject
    private InvocationManager invManager;
    private ComponentInvocationHandler ejbSecurityCompInvHandler = new ComponentInvocationHandler(){

        @Override
        public void beforePreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation newInv) throws InvocationException {
            if (invType == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                assert (newInv instanceof EjbInvocation);
                try {
                    if (!newInv.isPreInvokeDone()) {
                        ((EjbInvocation)newInv).getEjbSecurityManager().preInvoke(newInv);
                    }
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "ejb.security_preinvoke_exception", ex);
                    throw new InvocationException(ex);
                }
            }
        }

        @Override
        public void afterPreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }

        @Override
        public void beforePostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }

        @Override
        public void afterPostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
            if (invType == ComponentInvocation.ComponentInvocationType.EJB_INVOCATION) {
                assert (curInv instanceof EjbInvocation);
                try {
                    ((EjbInvocation)curInv).getEjbSecurityManager().postInvoke(curInv);
                }
                catch (Exception ex) {
                    _logger.log(Level.SEVERE, "ejb.security_postinvoke_exception", ex);
                    ((EjbInvocation)curInv).exception = ex;
                }
            }
        }
    };

    @Override
    public ComponentInvocationHandler getComponentInvocationHandler() {
        return this.ejbSecurityCompInvHandler;
    }

    @Override
    public void register() {
        this.invManager.registerComponentInvocationHandler(ComponentInvocation.ComponentInvocationType.EJB_INVOCATION, this);
    }
}

