/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http2.AlpnSupport;
import org.glassfish.grizzly.http2.DraftVersion;
import org.glassfish.grizzly.http2.Http2ClientFilter;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.npn.AlpnClientNegotiator;

class AlpnClientNegotiatorImpl
implements AlpnClientNegotiator {
    private static final Logger LOGGER = Grizzly.logger(AlpnClientNegotiatorImpl.class);
    private static final String HTTP11 = "http/1.1";
    private final String[] supportedProtocolsStr;
    private final Http2ClientFilter filter;

    public AlpnClientNegotiatorImpl(DraftVersion[] supportedHttp2Drafts, Http2ClientFilter filter) {
        this.filter = filter;
        this.supportedProtocolsStr = new String[supportedHttp2Drafts.length + 1];
        for (int i = 0; i < supportedHttp2Drafts.length; ++i) {
            this.supportedProtocolsStr[i] = supportedHttp2Drafts[i].getTlsId();
        }
        this.supportedProtocolsStr[this.supportedProtocolsStr.length - 1] = HTTP11;
    }

    @Override
    public String[] getProtocols(SSLEngine sslEngine) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Alpn getProtocols. Connection={0}, protocols={1}", new Object[]{AlpnSupport.getConnection(sslEngine), Arrays.toString(this.supportedProtocolsStr)});
        }
        return this.supportedProtocolsStr;
    }

    @Override
    public void protocolSelected(SSLEngine sslEngine, String selectedProtocol) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.log(Level.INFO, "Alpn protocolSelected. Connection={0}, protocol={1}", new Object[]{AlpnSupport.getConnection(sslEngine), selectedProtocol});
        }
        Connection connection = AlpnSupport.getConnection(sslEngine);
        DraftVersion draft = DraftVersion.fromString(selectedProtocol);
        if (draft != null) {
            Http2Connection http2Connection = this.filter.createClientHttp2Connection(draft, connection);
            http2Connection.getHttp2State().setDirectUpgradePhase();
            http2Connection.sendPreface();
        } else {
            Http2State.create(connection).setNeverHttp2();
        }
    }
}

