/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2ConnectionException;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.memory.Buffers;
import org.glassfish.grizzly.memory.MemoryManager;

public class Http2FrameCodec {
    private static final Logger LOGGER = Grizzly.logger(Http2FrameCodec.class);
    private static final Level LOGGER_LEVEL = Level.INFO;

    public List<Http2Frame> parse(Http2Connection http2Connection, FrameParsingState parsingState, Buffer srcMessage) throws Http2ConnectionException {
        if (parsingState.bytesToSkip() > 0 && !this.skip(parsingState, srcMessage)) {
            return null;
        }
        srcMessage = parsingState.appendToRemainder(http2Connection.getMemoryManager(), srcMessage);
        ParsingResult parsingResult = this.parseFrame(http2Connection, parsingState, srcMessage);
        if (!parsingResult.isReady()) {
            return null;
        }
        boolean logit = LOGGER.isLoggable(LOGGER_LEVEL);
        if (logit) {
            LOGGER.log(LOGGER_LEVEL, "Rx [1]: connection={0}, frame={1}", new Object[]{Http2FrameCodec.makeString(http2Connection.getConnection()), Http2FrameCodec.makeString(parsingResult.frameList().get(parsingResult.frameList().size() - 1))});
        }
        Buffer remainder = parsingResult.remainder();
        while (remainder.remaining() >= http2Connection.getFrameHeaderSize()) {
            parsingResult = this.parseFrame(http2Connection, parsingState, remainder);
            if (!parsingResult.isReady()) {
                return parsingResult.frameList();
            }
            remainder = parsingResult.remainder();
            if (!logit) continue;
            LOGGER.log(LOGGER_LEVEL, "Rx [2]: connection={0}, frame={1}", new Object[]{Http2FrameCodec.makeString(http2Connection.getConnection()), Http2FrameCodec.makeString(parsingResult.frameList().get(parsingResult.frameList().size() - 1))});
        }
        return parsingResult.frameList();
    }

    public Buffer serializeAndRecycle(Http2Connection http2Connection, Http2Frame frame) {
        if (LOGGER.isLoggable(LOGGER_LEVEL)) {
            LOGGER.log(LOGGER_LEVEL, "Tx: connection={0}, frame={1}", new Object[]{Http2FrameCodec.makeString(http2Connection.getConnection()), Http2FrameCodec.makeString(frame)});
        }
        Buffer resultBuffer = frame.toBuffer(http2Connection);
        frame.recycle();
        return resultBuffer;
    }

    public Buffer serializeAndRecycle(Http2Connection http2Connection, List<Http2Frame> frames) {
        if (LOGGER.isLoggable(LOGGER_LEVEL)) {
            LOGGER.log(LOGGER_LEVEL, "Tx: connection={0}, frames={1}", new Object[]{Http2FrameCodec.makeString(http2Connection.getConnection()), Http2FrameCodec.makeString(frames)});
        }
        Buffer resultBuffer = null;
        int framesCount = frames.size();
        for (int i = 0; i < framesCount; ++i) {
            Http2Frame frame = frames.get(i);
            Buffer buffer = frame.toBuffer(http2Connection);
            frame.recycle();
            resultBuffer = Buffers.appendBuffers(http2Connection.getMemoryManager(), resultBuffer, buffer);
        }
        frames.clear();
        return resultBuffer;
    }

    private ParsingResult parseFrame(Http2Connection http2Connection, FrameParsingState state, Buffer buffer) throws Http2ConnectionException {
        int frameHeaderSize = http2Connection.getFrameHeaderSize();
        int bufferSize = buffer.remaining();
        ParsingResult parsingResult = state.parsingResult();
        if (bufferSize < frameHeaderSize) {
            return parsingResult.setNeedMore(buffer);
        }
        int len = http2Connection.getFrameSize(buffer);
        if (len > http2Connection.getLocalMaxFramePayloadSize() + frameHeaderSize) {
            Buffer remainder;
            http2Connection.onOversizedFrame(buffer);
            buffer.position(buffer.position() + frameHeaderSize);
            int remaining = buffer.remaining();
            if (remaining > len) {
                int bufferPos = buffer.position();
                remainder = buffer.split(bufferPos + len);
            } else {
                remainder = Buffers.EMPTY_BUFFER;
                state.bytesToSkip(len - remaining);
            }
            return parsingResult.setParsed(null, remainder);
        }
        if (buffer.remaining() < len) {
            return parsingResult.setNeedMore(buffer);
        }
        Buffer remainder = buffer.split(buffer.position() + len);
        Http2Frame frame = http2Connection.parseHttp2FrameHeader(buffer);
        return parsingResult.setParsed(frame, remainder);
    }

    private boolean skip(FrameParsingState parsingState, Buffer message) {
        int bytesToSkip = parsingState.bytesToSkip();
        int dec = Math.min(bytesToSkip, message.remaining());
        parsingState.bytesToSkip(bytesToSkip - dec);
        message.position(message.position() + dec);
        if (message.hasRemaining()) {
            message.shrink();
            return true;
        }
        message.tryDispose();
        return false;
    }

    private static String makeString(Object o) {
        return o == null ? null : o.toString();
    }

    static final class ParsingResult {
        private Buffer remainder;
        private boolean isReady;
        private final List<Http2Frame> frameList = new ArrayList<Http2Frame>(4);

        private ParsingResult() {
        }

        ParsingResult setParsed(Http2Frame frame, Buffer remainder) {
            if (frame != null) {
                this.frameList.add(frame);
            }
            this.remainder = remainder;
            this.isReady = true;
            return this;
        }

        ParsingResult setNeedMore(Buffer remainder) {
            this.remainder = remainder;
            this.isReady = false;
            return this;
        }

        List<Http2Frame> frameList() {
            return this.frameList;
        }

        Buffer remainder() {
            return this.remainder;
        }

        boolean isReady() {
            return this.isReady;
        }
    }

    public static final class FrameParsingState {
        private int bytesToSkip;
        private final ParsingResult parsingResult = new ParsingResult();

        List<Http2Frame> getList() {
            return this.parsingResult.frameList;
        }

        Buffer appendToRemainder(MemoryManager mm, Buffer buffer) {
            Buffer remainderBuffer = this.parsingResult.remainder;
            this.parsingResult.remainder = null;
            return Buffers.appendBuffers(mm, remainderBuffer, buffer, true);
        }

        int bytesToSkip() {
            return this.bytesToSkip;
        }

        void bytesToSkip(int bytesToSkip) {
            this.bytesToSkip = bytesToSkip;
        }

        ParsingResult parsingResult() {
            return this.parsingResult;
        }
    }
}

