/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.http.HttpBrokenContentException;
import org.glassfish.grizzly.http.HttpContent;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpEvents;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.http2.DraftVersion;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.Http2ConnectionException;
import org.glassfish.grizzly.http2.Http2State;
import org.glassfish.grizzly.http2.Http2Stream;
import org.glassfish.grizzly.http2.Http2StreamException;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.http2.frames.SettingsFrame;

public class Http2ServerFilter
extends Http2BaseFilter {
    private boolean allowPayloadForUndefinedHttpMethods;

    public Http2ServerFilter() {
        this((ExecutorService)null, ALL_HTTP2_DRAFTS);
    }

    public Http2ServerFilter(DraftVersion ... supportedDraftVersions) {
        this((ExecutorService)null, supportedDraftVersions);
    }

    public Http2ServerFilter(ExecutorService threadPool, DraftVersion ... supportedDraftVersions) {
        super(threadPool, supportedDraftVersions);
    }

    public boolean isAllowPayloadForUndefinedHttpMethods() {
        return this.allowPayloadForUndefinedHttpMethods;
    }

    public void setAllowPayloadForUndefinedHttpMethods(boolean allowPayloadForUndefinedHttpMethods) {
        this.allowPayloadForUndefinedHttpMethods = allowPayloadForUndefinedHttpMethods;
    }

    @Override
    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer framePayload;
        Http2Connection http2Connection;
        if (this.checkIfHttp2StreamChain(ctx)) {
            return ctx.getInvokeAction();
        }
        Connection connection = ctx.getConnection();
        Http2State http2State = Http2State.get(connection);
        if (http2State != null && http2State.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        HttpContent httpContent = (HttpContent)ctx.getMessage();
        HttpHeader httpHeader = httpContent.getHttpHeader();
        if (http2State == null) {
            assert (httpHeader.isRequest());
            if (httpHeader.isSecure()) {
                Http2State.create(connection).setNeverHttp2();
                return ctx.getInvokeAction();
            }
            HttpRequestPacket httpRequest = (HttpRequestPacket)httpHeader;
            if (!Method.PRI.equals(httpRequest.getMethod())) {
                boolean isLast = httpContent.isLast();
                if (this.tryHttpUpgrade(ctx, httpRequest, isLast) && isLast) {
                    this.enableOpReadNow(ctx);
                }
                return ctx.getInvokeAction();
            }
            http2State = this.doDirectUpgrade(ctx);
        }
        if (!(http2Connection = this.obtainHttp2Connection(http2State, ctx, true)).isHttp2InputEnabled()) {
            if (http2State.isHttpUpgradePhase()) {
                if (httpContent.isLast()) {
                    http2State.setDirectUpgradePhase();
                    this.enableOpReadNow(ctx);
                }
                return ctx.getInvokeAction();
            }
            HttpRequestPacket httpRequest = (HttpRequestPacket)httpHeader;
            try {
                if (!this.checkPRI(ctx, httpRequest, httpContent)) {
                    return ctx.getStopAction(httpContent);
                }
            }
            catch (Exception e) {
                httpRequest.getProcessingState().setError(true);
                httpRequest.getProcessingState().setKeepAlive(false);
                HttpResponsePacket httpResponse = httpRequest.getResponse();
                httpResponse.setStatus(HttpStatus.BAD_REQUEST_400);
                ctx.write(httpResponse);
                connection.closeSilently();
                return ctx.getStopAction();
            }
            Buffer payload = httpContent.getContent();
            framePayload = payload.split(payload.position() + PRI_PAYLOAD.length);
        } else {
            framePayload = httpContent.getContent();
        }
        httpContent.recycle();
        List<Http2Frame> framesList = this.frameCodec.parse(http2Connection, http2State.getFrameParsingState(), framePayload);
        if (!this.processFrames(ctx, http2Connection, framesList)) {
            return ctx.getSuspendAction();
        }
        return ctx.getStopAction();
    }

    @Override
    public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
        Object type2 = event.type();
        if (type2 == HttpEvents.IncomingHttpUpgradeEvent.TYPE) {
            HttpHeader header = ((HttpEvents.IncomingHttpUpgradeEvent)event).getHttpHeader();
            if (header.isRequest() && this.checkRequestHeadersOnUpgrade((HttpRequestPacket)header)) {
                header.setIgnoreContentModifiers(false);
                return ctx.getStopAction();
            }
            return ctx.getInvokeAction();
        }
        Http2State state = Http2State.get(ctx.getConnection());
        if (state == null || state.isNeverHttp2()) {
            return ctx.getInvokeAction();
        }
        if (type2 == HttpEvents.ResponseCompleteEvent.TYPE) {
            HttpContext httpContext = HttpContext.get(ctx);
            Http2Stream stream = (Http2Stream)httpContext.getContextStorage();
            stream.onProcessingComplete();
            Http2Connection http2Connection = stream.getHttp2Connection();
            if (!http2Connection.isHttp2InputEnabled()) {
                state.finishHttpUpgradePhase();
                return ctx.getInvokeAction();
            }
            return ctx.getStopAction();
        }
        return super.handleEvent(ctx, event);
    }

    @Override
    protected void onPrefaceReceived(Http2Connection http2Connection) {
        http2Connection.sendPreface();
    }

    private Http2State doDirectUpgrade(FilterChainContext ctx) {
        Connection connection = ctx.getConnection();
        DraftVersion version = this.getSupportedHttp2Drafts()[0];
        Http2Connection http2Connection = version.newConnection(connection, true, this);
        Http2State http2State = Http2State.create(connection);
        http2State.setHttp2Connection(http2Connection);
        http2State.setDirectUpgradePhase();
        http2Connection.setupFilterChains(ctx, true);
        http2Connection.sendPreface();
        return http2State;
    }

    private boolean tryHttpUpgrade(FilterChainContext ctx, HttpRequestPacket httpRequest, boolean isLast) throws Http2StreamException {
        if (!this.checkHttpMethodOnUpgrade(httpRequest)) {
            return false;
        }
        if (!this.checkRequestHeadersOnUpgrade(httpRequest)) {
            return false;
        }
        DraftVersion version = this.getHttp2UpgradingVersion(httpRequest);
        if (version == null) {
            return false;
        }
        SettingsFrame settingsFrame = this.getHttp2UpgradeSettings(httpRequest);
        if (settingsFrame == null) {
            return false;
        }
        Connection connection = ctx.getConnection();
        Http2Connection http2Connection = version.newConnection(connection, true, this);
        Http2State http2State = Http2State.create(connection);
        http2State.setHttp2Connection(http2Connection);
        if (isLast) {
            http2State.setDirectUpgradePhase();
        }
        try {
            this.applySettings(http2Connection, settingsFrame);
        }
        catch (Http2ConnectionException e) {
            Http2State.remove(connection);
            return false;
        }
        HttpResponsePacket httpResponse = httpRequest.getResponse();
        httpResponse.setStatus(HttpStatus.SWITCHING_PROTOCOLS_101);
        httpResponse.setHeader(Header.Connection, "Upgrade");
        httpResponse.setHeader(Header.Upgrade, version.getClearTextId());
        httpResponse.setIgnoreContentModifiers(true);
        ctx.write(httpResponse);
        httpResponse.setCommitted(false);
        http2Connection.setupFilterChains(ctx, true);
        http2Connection.sendPreface();
        httpResponse.setStatus(HttpStatus.OK_200);
        httpResponse.getHeaders().clear();
        httpRequest.setProtocol(Protocol.HTTP_2_0);
        httpResponse.setProtocol(Protocol.HTTP_2_0);
        httpRequest.getUpgradeDC().recycle();
        httpResponse.getProcessingState().setKeepAlive(true);
        Http2Stream stream = http2Connection.openUpgradeStream(httpRequest, 0, !httpRequest.isExpectContent());
        HttpContext httpContext = HttpContext.newInstance(stream, stream, stream, httpRequest);
        httpRequest.getProcessingState().setHttpContext(httpContext);
        httpRequest.setAttribute(Http2Stream.HTTP2_STREAM_ATTRIBUTE, stream);
        httpContext.attach(ctx);
        return true;
    }

    private boolean checkHttpMethodOnUpgrade(HttpRequestPacket httpRequest) {
        return httpRequest.getMethod() != Method.CONNECT;
    }

    private boolean checkPRI(FilterChainContext ctx, HttpRequestPacket httpRequest, HttpContent httpContent) {
        if (!Method.PRI.equals(httpRequest.getMethod())) {
            throw new HttpBrokenContentException();
        }
        Buffer payload = httpContent.getContent();
        if (payload.remaining() < PRI_PAYLOAD.length) {
            return false;
        }
        int pos = payload.position();
        for (int i = 0; i < PRI_PAYLOAD.length; ++i) {
            if (payload.get(pos + i) == PRI_PAYLOAD[i]) continue;
            throw new HttpBrokenContentException();
        }
        return true;
    }

    private void enableOpReadNow(FilterChainContext ctx) {
        FilterChainContext newContext = ctx.copy();
        ctx.getInternalContext().removeAllLifeCycleListeners();
        newContext.resume(newContext.getStopAction());
    }
}

