/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.compression;

import java.io.IOException;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.http2.hpack.Encoder;
import org.glassfish.grizzly.http2.hpack.Hpack;
import org.glassfish.grizzly.memory.MemoryManager;
import org.glassfish.grizzly.utils.BufferOutputStream;

public class HeadersEncoder {
    private final Encoder hpackEncoder;
    private final BufferOutputStream outputStream;

    public HeadersEncoder(MemoryManager memoryManager, int maxHeaderTableSize) {
        this.hpackEncoder = Hpack.newEncoder(maxHeaderTableSize);
        this.outputStream = new BufferOutputStream(memoryManager);
    }

    public void encodeHeader(String name, String value) throws IOException {
        this.hpackEncoder.encode(name, value, this.outputStream);
    }

    public Buffer flushHeaders() throws IOException {
        Buffer buffer = this.outputStream.getBuffer();
        buffer.trim();
        this.outputStream.reset();
        return buffer;
    }
}

