/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli.internal;

import com.sun.enterprise.config.serverbeans.Resources;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jdbcruntime.service.JdbcAdminServiceImpl;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-validation-class-names")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-validation-class-names", description="Get Validation Class Names")})
public class GetValidationClassNames
implements AdminCommand {
    @Inject
    private JdbcAdminServiceImpl jdbcAdminService;
    @Param
    private String className;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            Set<String> validationClassNames = this.jdbcAdminService.getValidationClassNames(this.className);
            Properties extraProperties = new Properties();
            extraProperties.put("validationClassNames", new ArrayList<String>(validationClassNames));
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-validation-class-names failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

