/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.gf.ejb.internal;

import javax.ejb.EJBException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.glassfish.jersey.spi.ExceptionMappers;
import org.glassfish.jersey.spi.ExtendedExceptionMapper;

public class EjbExceptionMapper
implements ExtendedExceptionMapper<EJBException> {
    private final Provider<ExceptionMappers> mappers;

    @Inject
    public EjbExceptionMapper(Provider<ExceptionMappers> mappers) {
        this.mappers = mappers;
    }

    @Override
    public Response toResponse(EJBException exception) {
        return this.causeToResponse(exception);
    }

    @Override
    public boolean isMappable(EJBException exception) {
        try {
            return this.causeToResponse(exception) != null;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private Response causeToResponse(EJBException exception) {
        Exception cause = exception.getCausedByException();
        if (cause != null) {
            ExceptionMapper<Exception> mapper = this.mappers.get().findMapping(cause);
            if (mapper != null && mapper != this) {
                return mapper.toResponse(cause);
            }
            if (cause instanceof WebApplicationException) {
                return ((WebApplicationException)cause).getResponse();
            }
        }
        return null;
    }
}

