/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.basic.func.UnaryVoidFunction;
import org.glassfish.pfl.dynamic.codegen.spi.ImportList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;

public class ImportListImpl
implements ImportList {
    private Map<String, Type> imports = new HashMap<String, Type>();
    private Node root;
    private List<Pair<String, String>> sortedImports;

    public ImportListImpl() {
        this.clearRoot();
    }

    @Override
    public ImportList copy() {
        ImportListImpl result = new ImportListImpl();
        result.imports = new HashMap<String, Type>(this.imports);
        return result;
    }

    private void clearRoot() {
        this.root = null;
        this.sortedImports = null;
    }

    @Override
    public Type addImport(String name) {
        Type result = Type._class(name);
        this.addImport(result);
        return result;
    }

    @Override
    public void addImport(Type type2) {
        String key = type2.className();
        if (!this.imports.entrySet().contains(key)) {
            this.imports.put(key, type2);
            this.clearRoot();
        }
    }

    @Override
    public boolean contains(String name) {
        Type type2 = Type._class(name);
        return this.contains(type2);
    }

    @Override
    public boolean contains(Type type2) {
        String key = type2.className();
        Type importType = this.imports.get(key);
        if (importType == null) {
            return false;
        }
        return importType.equals(type2);
    }

    @Override
    public Type lookup(String className) {
        return this.imports.get(className);
    }

    private void insertType(Type type2) {
        String packageName = type2.packageName();
        String[] packages = packageName.split("[.]");
        String className = type2.className();
        Node current = this.root;
        for (String pkg : packages) {
            if (current.children() == null) {
                return;
            }
            Node next = current.find(pkg);
            if (next == null) {
                next = Node.makeListNode(pkg);
                current.add(next);
            }
            current = next;
        }
        Node classNode = current.find(className);
        if (classNode == null) {
            classNode = Node.makeTypeNode(className, type2);
            current.add(classNode);
        }
    }

    private void updateRoot() {
        if (this.root != null) {
            return;
        }
        this.root = Node.makeListNode("");
        for (Type type2 : this.imports.values()) {
            this.insertType(type2);
        }
        this.root.sort();
    }

    @Override
    public List<Pair<String, String>> getInOrderList() {
        if (this.sortedImports != null) {
            return this.sortedImports;
        }
        this.updateRoot();
        this.sortedImports = new ArrayList<Pair<String, String>>();
        UnaryVoidFunction<Node> fn = new UnaryVoidFunction<Node>(){

            @Override
            public void evaluate(Node node) {
                Type type2 = node.type();
                if (type2 == null) {
                    return;
                }
                Pair<String, String> pair = new Pair<String, String>(type2.packageName(), type2.className());
                ImportListImpl.this.sortedImports.add(pair);
            }
        };
        this.root.depthFirst(fn);
        return this.sortedImports;
    }

    private static abstract class Node
    implements Comparable<Node> {
        private final String name;

        private Node(String name) {
            this.name = name;
        }

        public final String name() {
            return this.name;
        }

        @Override
        public final int compareTo(Node node) {
            return this.name.compareTo(node.name());
        }

        public Type type() {
            return null;
        }

        public List<Node> children() {
            return null;
        }

        public void sort() {
        }

        public Node find(String name) {
            return null;
        }

        public void add(Node node) {
        }

        public void depthFirst(UnaryVoidFunction<Node> fn) {
            fn.evaluate(this);
        }

        public static Node makeTypeNode(String name, final Type type2) {
            return new Node(name){

                @Override
                public Type type() {
                    return type2;
                }
            };
        }

        public static Node makeListNode(String name) {
            return new Node(name){
                final List<Node> children = new ArrayList<Node>();

                @Override
                public List<Node> children() {
                    return this.children;
                }

                @Override
                public void sort() {
                    Collections.sort(this.children);
                    for (Node node : this.children) {
                        node.sort();
                    }
                }

                @Override
                public Node find(String name) {
                    for (Node n : this.children) {
                        if (!n.name().equals(name)) continue;
                        return n;
                    }
                    return null;
                }

                @Override
                public void add(Node node) {
                    this.children.add(node);
                }

                @Override
                public void depthFirst(UnaryVoidFunction<Node> fn) {
                    for (Node node : this.children) {
                        node.depthFirst(fn);
                    }
                }
            };
        }
    }
}

