/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.dynamic.codegen.impl.BlockStatement;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.impl.StatementBase;
import org.glassfish.pfl.dynamic.codegen.impl.Visitor;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Variable;

public final class TryStatement
extends StatementBase {
    private BlockStatement bodyPart = new BlockStatement(this);
    private BlockStatement finalPart = new BlockStatement(this);
    private Map<Type, Pair<Variable, BlockStatement>> catches = new LinkedHashMap<Type, Pair<Variable, BlockStatement>>();

    TryStatement(Node parent) {
        super(parent);
    }

    public BlockStatement bodyPart() {
        return this.bodyPart;
    }

    public BlockStatement finalPart() {
        return this.finalPart;
    }

    public Map<Type, Pair<Variable, BlockStatement>> catches() {
        return this.catches;
    }

    public Pair<Variable, BlockStatement> addCatch(Type type2, String ident) {
        if (type2.isPrimitive()) {
            throw new IllegalArgumentException("Primitive type " + type2 + " not allowed in catch block");
        }
        if (type2.isArray()) {
            throw new IllegalArgumentException("Array type " + type2 + " not allowed in catch block");
        }
        if (this.catches.containsKey(type2)) {
            throw new IllegalArgumentException("Type " + type2 + " is already used as a catch block in this try statement");
        }
        BlockStatement stmt = new BlockStatement(this);
        Variable var = stmt.exprFactory().variable(type2, ident);
        Pair<Variable, BlockStatement> result = new Pair<Variable, BlockStatement>(var, stmt);
        this.catches.put(type2, result);
        return result;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitTryStatement(this);
    }
}

