/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hk2.osgiadapter;

import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModuleDefinition;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import org.jvnet.hk2.osgiadapter.AbstractOSGiModulesRegistryImpl;
import org.jvnet.hk2.osgiadapter.Logger;
import org.jvnet.hk2.osgiadapter.ModuleDefinitionCacheSingleton;
import org.jvnet.hk2.osgiadapter.OSGiModuleDefinition;
import org.jvnet.hk2.osgiadapter.OSGiModuleImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class OSGiModulesRegistryImpl
extends AbstractOSGiModulesRegistryImpl
implements SynchronousBundleListener {
    ModuleDefinitionCacheSingleton cache = ModuleDefinitionCacheSingleton.getInstance();

    OSGiModulesRegistryImpl(BundleContext bctx) {
        super(bctx);
        bctx.addBundleListener((BundleListener)this);
        for (Bundle b : bctx.getBundles()) {
            if (b.getLocation().equals("System Bundle")) continue;
            try {
                this.add(this.makeModule(b));
            }
            catch (Exception e) {
                Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "OSGiModulesRegistryImpl", "Not able convert bundle [{0}] having location [{1}] to module because of exception: {2}", new Object[]{b, b.getLocation(), e});
            }
        }
        if (this.cache.isCacheInvalidated()) {
            try {
                this.cache.saveCache();
            }
            catch (IOException e) {
                Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "OSGiModulesRegistryImpl", "Could not save module definition cache", e);
            }
        }
    }

    public void bundleChanged(BundleEvent event) {
        try {
            Bundle bundle2 = event.getBundle();
            switch (event.getType()) {
                case 1: {
                    if (!Logger.logger.isLoggable(Level.FINE)) break;
                    Logger.logger.fine("[" + bundle2.getBundleId() + "] " + bundle2.getSymbolicName() + " installed");
                    break;
                }
                case 32: {
                    OSGiModuleImpl m = this.makeModule(bundle2);
                    this.add(m);
                    break;
                }
                case 16: {
                    Module m = this.getModule(bundle2);
                    if (m == null) break;
                    this.remove(m);
                    break;
                }
                case 8: {
                    Module m = this.getModule(bundle2);
                    if (m != null) {
                        this.remove(m);
                    }
                    this.add(this.makeModule(bundle2));
                }
            }
        }
        catch (Exception e) {
            Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "bundleChanged", e.getMessage(), e);
        }
    }

    private OSGiModuleImpl makeModule(Bundle bundle2) throws IOException, URISyntaxException {
        OSGiModuleDefinition md = this.makeModuleDef(bundle2);
        OSGiModuleImpl m = new OSGiModuleImpl(this, bundle2, md);
        return m;
    }

    private OSGiModuleDefinition makeModuleDef(Bundle bundle2) throws IOException, URISyntaxException {
        URI key = OSGiModuleDefinition.toURI(bundle2);
        ModuleDefinition md = this.cache.get(key);
        if (md != null) {
            return (OSGiModuleDefinition)OSGiModuleDefinition.class.cast(md);
        }
        this.cache.invalidate();
        md = new OSGiModuleDefinition(bundle2);
        this.cache.cacheModuleDefinition(key, md);
        return (OSGiModuleDefinition)md;
    }

    @Override
    protected synchronized void add(Module newModule) {
        super.add(newModule);
    }

    @Override
    public synchronized void remove(Module module) {
        super.remove(module);
        URI location = module.getModuleDefinition().getLocations()[0];
        this.cache.remove(location);
    }

    @Override
    protected Module newModule(ModuleDefinition moduleDef) {
        String location = moduleDef.getLocations()[0].toString();
        try {
            File l;
            if (Logger.logger.isLoggable(Level.FINE)) {
                Logger.logger.logp(Level.FINE, "OSGiModulesRegistryImpl", "newModule", "location = {0}", location);
            }
            if ((l = new File(moduleDef.getLocations()[0])).isDirectory()) {
                location = "reference:" + location;
            }
            Bundle bundle2 = this.bctx.installBundle(location);
            return new OSGiModuleImpl(this, bundle2, moduleDef);
        }
        catch (BundleException e) {
            Logger.logger.logp(Level.WARNING, "OSGiModulesRegistryImpl", "newModule", "Exception {0} while adding location = {1}", new Object[]{e, location});
            return null;
        }
    }

    @Override
    public synchronized void shutdown() {
        for (Module m : this.modules.values()) {
            if (!((OSGiModuleImpl)OSGiModuleImpl.class.cast(m)).isTransientlyActive()) continue;
            m.stop();
        }
        try {
            this.cache.saveCache();
        }
        catch (IOException e) {
            Logger.logger.log(Level.WARNING, "Cannot save metadata to cache", e);
        }
        this.bctx.removeBundleListener((BundleListener)this);
        super.shutdown();
    }

    protected String getProperty(String property) {
        String value = this.bctx.getProperty(property);
        if (value == null) {
            value = System.getProperty(property);
        }
        return value;
    }
}

