/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.cluster.impl.ClusterClockImpl;
import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.JoinOperation;
import com.hazelcast.cluster.impl.operations.MemberInfoUpdateOperation;
import com.hazelcast.cluster.impl.operations.PostJoinOperation;
import com.hazelcast.core.Member;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.partition.PartitionRuntimeState;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationAccessor;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.OperationResponseHandlerFactory;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;

public class FinalizeJoinOperation
extends MemberInfoUpdateOperation
implements JoinOperation {
    public static final int FINALIZE_JOIN_TIMEOUT_FACTOR = 5;
    public static final int FINALIZE_JOIN_MAX_TIMEOUT = 60;
    private PostJoinOperation postJoinOp;
    private PartitionRuntimeState partitionRuntimeState;
    private String clusterId;
    private long clusterStartTime;
    private ClusterState clusterState;

    public FinalizeJoinOperation() {
    }

    public FinalizeJoinOperation(Collection<MemberInfo> members, PostJoinOperation postJoinOp, long masterTime, String clusterId, long clusterStartTime, ClusterState clusterState, PartitionRuntimeState partitionRuntimeState) {
        super(members, masterTime, true);
        this.postJoinOp = postJoinOp;
        this.clusterId = clusterId;
        this.clusterStartTime = clusterStartTime;
        this.clusterState = clusterState;
        this.partitionRuntimeState = partitionRuntimeState;
    }

    public FinalizeJoinOperation(Collection<MemberInfo> members, PostJoinOperation postJoinOp, long masterTime, ClusterState clusterState, PartitionRuntimeState partitionRuntimeState, boolean sendResponse) {
        super(members, masterTime, sendResponse);
        this.postJoinOp = postJoinOp;
        this.clusterState = clusterState;
        this.partitionRuntimeState = partitionRuntimeState;
    }

    @Override
    public void run() throws Exception {
        if (!this.isValid()) {
            return;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        if (nodeEngine.getNode().joined()) {
            ILogger logger2 = this.getLogger();
            if (logger2.isFinestEnabled()) {
                logger2.finest("Node is already joined... No need to finalize join...");
            }
            return;
        }
        this.initClusterStates(clusterService);
        this.processMemberUpdate();
        this.processPartitionState();
        this.sendPostJoinOperations();
        this.runPostJoinOp();
    }

    private void initClusterStates(ClusterServiceImpl clusterService) {
        clusterService.initialClusterState(this.clusterState);
        clusterService.setClusterId(this.clusterId);
        ClusterClockImpl clusterClock = clusterService.getClusterClock();
        clusterClock.setClusterStartTime(this.clusterStartTime);
        clusterClock.setMasterTime(this.masterTime);
    }

    private void processPartitionState() {
        if (this.partitionRuntimeState == null) {
            return;
        }
        this.partitionRuntimeState.setEndpoint(this.getCallerAddress());
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        Node node = clusterService.getNodeEngine().getNode();
        node.partitionService.processPartitionRuntimeState(this.partitionRuntimeState);
    }

    private void runPostJoinOp() {
        if (this.postJoinOp == null) {
            return;
        }
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        InternalOperationService operationService = nodeEngine.getOperationService();
        this.postJoinOp.setNodeEngine(nodeEngine);
        OperationAccessor.setCallerAddress(this.postJoinOp, this.getCallerAddress());
        OperationAccessor.setConnection(this.postJoinOp, this.getConnection());
        this.postJoinOp.setOperationResponseHandler(OperationResponseHandlerFactory.createEmptyResponseHandler());
        operationService.runOperationOnCallingThread(this.postJoinOp);
    }

    private void sendPostJoinOperations() {
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService();
        NodeEngineImpl nodeEngine = clusterService.getNodeEngine();
        Operation[] postJoinOperations = nodeEngine.getPostJoinOperations();
        InternalOperationService operationService = nodeEngine.getOperationService();
        if (postJoinOperations != null && postJoinOperations.length > 0) {
            Set<Member> members = clusterService.getMembers();
            for (Member member : members) {
                if (member.localMember()) continue;
                PostJoinOperation operation = new PostJoinOperation(postJoinOperations);
                operationService.createInvocationBuilder("hz:core:clusterService", (Operation)operation, member.getAddress()).setTryCount(100).invoke();
            }
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        boolean hasPJOp = this.postJoinOp != null;
        out.writeBoolean(hasPJOp);
        if (hasPJOp) {
            this.postJoinOp.writeData(out);
        }
        out.writeUTF(this.clusterId);
        out.writeLong(this.clusterStartTime);
        out.writeUTF(this.clusterState.toString());
        out.writeObject(this.partitionRuntimeState);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        boolean hasPJOp = in.readBoolean();
        if (hasPJOp) {
            this.postJoinOp = new PostJoinOperation();
            this.postJoinOp.readData(in);
        }
        this.clusterId = in.readUTF();
        this.clusterStartTime = in.readLong();
        String stateName = in.readUTF();
        this.clusterState = ClusterState.valueOf(stateName);
        this.partitionRuntimeState = (PartitionRuntimeState)in.readObject();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", postJoinOp=").append(this.postJoinOp);
    }

    @Override
    public int getId() {
        return 7;
    }
}

