/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl.operations;

import com.hazelcast.cluster.impl.ClusterServiceImpl;
import com.hazelcast.cluster.impl.operations.AbstractClusterOperation;
import com.hazelcast.cluster.impl.operations.JoinOperation;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public final class HeartbeatOperation
extends AbstractClusterOperation
implements JoinOperation,
IdentifiedDataSerializable {
    private long timestamp;

    public HeartbeatOperation() {
    }

    public HeartbeatOperation(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void run() {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        MemberImpl member = service.getMember(this.getCallerAddress());
        if (member == null) {
            ILogger logger2 = this.getLogger();
            if (logger2.isFinestEnabled()) {
                logger2.finest("Heartbeat received from an unknown endpoint: " + this.getCallerAddress());
            }
            return;
        }
        service.getClusterHeartbeatManager().onHeartbeat(member, this.timestamp);
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 3;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeLong(this.timestamp);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.timestamp = in.readLong();
    }
}

