/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.impl.PacketHandler;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;

final class ResponsePacketHandlerImpl
implements PacketHandler {
    private final ILogger logger;
    private final SerializationService serializationService;
    private final InvocationRegistry invocationRegistry;

    public ResponsePacketHandlerImpl(ILogger logger2, SerializationService serializationService, InvocationRegistry invocationRegistry) {
        this.logger = logger2;
        this.serializationService = serializationService;
        this.invocationRegistry = invocationRegistry;
    }

    @Override
    public void handle(Packet packet) throws Exception {
        Response response = (Response)this.serializationService.toObject(packet);
        try {
            this.invocationRegistry.notify(response, packet.getConn().getEndPoint());
        }
        catch (Throwable e) {
            this.logger.severe("While processing response...", e);
        }
    }
}

