/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import com.sun.common.util.logging.BooleanLatch;
import com.sun.common.util.logging.GFLogRecord;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private static final int MAX_RECORDS = 5000;
    private String lineSeparator;
    private Logger logger;
    private Level level;
    private ThreadLocal reentrant = new ThreadLocal();
    private BlockingQueue<LogRecord> pendingRecords = new ArrayBlockingQueue<LogRecord>(5000);
    private BooleanLatch done = new BooleanLatch();
    private Thread pump;

    public LoggingOutputStream(Logger logger2, Level level) {
        this.logger = logger2;
        this.level = level;
        this.lineSeparator = System.getProperty("line.separator");
        this.initializePump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        String logMessage = null;
        LoggingOutputStream loggingOutputStream = this;
        synchronized (loggingOutputStream) {
            super.flush();
            logMessage = this.toString();
            super.reset();
        }
        logMessage = logMessage.trim();
        if (logMessage.length() == 0 || logMessage.equals(this.lineSeparator)) {
            return;
        }
        LogRecord logRecord = new LogRecord(this.level, logMessage);
        GFLogRecord logRecordWrapper = new GFLogRecord(logRecord);
        logRecordWrapper.setThreadName(Thread.currentThread().getName());
        this.pendingRecords.offer(logRecordWrapper);
    }

    private void initializePump() {
        this.pump = new Thread(){

            @Override
            public void run() {
                while (!LoggingOutputStream.this.done.isSignalled()) {
                    try {
                        LoggingOutputStream.this.log();
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.pump.setName("logging output pump");
        this.pump.setDaemon(true);
        this.pump.start();
    }

    public void log() {
        try {
            LogRecord record = this.pendingRecords.take();
            if (this.reentrant.get() != null) {
                return;
            }
            try {
                this.reentrant.set(this);
                this.logger.log(record);
            }
            finally {
                this.reentrant.set(null);
            }
        }
        catch (InterruptedException e) {
            return;
        }
        Vector v = new Vector();
        int size = this.pendingRecords.size();
        int msgs = this.pendingRecords.drainTo(v, size);
        for (int j = 0; j < msgs; ++j) {
            this.logger.log((LogRecord)v.get(j));
        }
    }

    @Override
    public void close() throws IOException {
        this.done.tryReleaseShared(1);
        this.pump.interrupt();
        int size = this.pendingRecords.size();
        if (size > 0) {
            ArrayList records = new ArrayList(size);
            this.pendingRecords.drainTo(records, size);
            for (LogRecord record : records) {
                this.logger.log(record);
            }
        }
        super.close();
    }

    private static class StackTraceObjects {
        private ByteArrayOutputStream stackTraceBuf = new ByteArrayOutputStream();
        private PrintStream stStream = new PrintStream(this.stackTraceBuf, true);
        private String stString;
        private ByteArrayOutputStream comparisonBuf = new ByteArrayOutputStream();
        private PrintStream cbStream = new PrintStream(this.comparisonBuf, true);
        private int stackTraceBufBytes = 0;
        private int charsIgnored = 0;

        private StackTraceObjects(Throwable x) {
            x.printStackTrace(this.stStream);
            this.stString = this.stackTraceBuf.toString();
            this.stackTraceBufBytes = this.stackTraceBuf.size();
            this.cbStream.println(x);
        }

        public String toString() {
            return this.stString;
        }

        boolean ignorePrintln(String str) {
            this.cbStream.println(str);
            String cbString = this.comparisonBuf.toString();
            int cbLen = cbString.length();
            if (this.stString.regionMatches(this.charsIgnored, cbString, 0, cbLen)) {
                this.charsIgnored += cbLen;
                this.comparisonBuf.reset();
                return true;
            }
            return false;
        }

        boolean checkCompletion() {
            return this.charsIgnored >= this.stackTraceBufBytes;
        }
    }

    public class LoggingPrintStream
    extends PrintStream {
        LogManager logManager;
        private ThreadLocal perThreadStObjects;

        public LoggingPrintStream(ByteArrayOutputStream os) {
            super(os, true);
            this.logManager = LogManager.getLogManager();
            this.perThreadStObjects = new ThreadLocal();
        }

        public void setLogger(Logger l) {
            LoggingOutputStream.this.logger = l;
        }

        @Override
        public void println(Object x) {
            if (!this.checkLocks()) {
                return;
            }
            if (!(x instanceof Throwable)) {
                this.println(String.valueOf(x));
                return;
            }
            StackTraceObjects sTO = new StackTraceObjects((Throwable)x);
            this.perThreadStObjects.set(sTO);
            super.println(sTO.toString());
        }

        @Override
        public PrintStream printf(String str, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.getDefault());
            formatter.format(str, args);
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream printf(Locale locale, String str, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, locale);
            formatter.format(str, args);
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream format(String format, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, Locale.getDefault());
            formatter.format(Locale.getDefault(), format, args);
            this.print(sb.toString());
            return null;
        }

        @Override
        public PrintStream format(Locale locale, String format, Object ... args) {
            StringBuilder sb = new StringBuilder();
            Formatter formatter = new Formatter(sb, locale);
            formatter.format(locale, format, args);
            this.print(sb.toString());
            return null;
        }

        @Override
        public void println(String str) {
            if (!this.checkLocks()) {
                return;
            }
            StackTraceObjects sTO = (StackTraceObjects)this.perThreadStObjects.get();
            if (sTO == null) {
                super.println(str);
                return;
            }
            if (!sTO.ignorePrintln(str)) {
                this.perThreadStObjects.set(null);
                super.println(str);
                return;
            }
            if (sTO.checkCompletion()) {
                this.perThreadStObjects.set(null);
                return;
            }
        }

        @Override
        public void print(String x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void print(Object x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void print(boolean x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(boolean x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(char x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(char x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(int x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(int x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(long x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(long x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(float x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(float x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(double x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(double x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void print(char[] x) {
            if (this.checkLocks()) {
                super.print(x);
            }
        }

        @Override
        public void println(char[] x) {
            if (this.checkLocks()) {
                super.println(x);
            }
        }

        @Override
        public void println() {
            if (this.checkLocks()) {
                super.println();
            }
        }

        @Override
        public void write(byte[] buf, int off, int len) {
            if (this.checkLocks()) {
                super.write(buf, off, len);
            }
        }

        @Override
        public void write(int b) {
            if (this.checkLocks()) {
                super.write(b);
            }
        }

        private boolean checkLocks() {
            Thread t = Thread.currentThread();
            if (!Thread.holdsLock(LoggingOutputStream.this.logger)) {
                if (!Thread.holdsLock(this.logManager)) {
                    return true;
                }
            }
            return false;
        }
    }
}

