/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.optional.BackupCommands;
import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.backup.ListManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.ObjectAnalyzer;
import java.io.File;
import org.glassfish.api.admin.CommandException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-backups")
@PerLookup
public final class ListBackupsCommand
extends BackupCommands {
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListBackupsCommand.class);

    @Override
    protected void validate() throws CommandException {
        if (this.domainName == null) {
            super.validate();
        }
        this.checkOptions();
        File domainFile = new File(new File(this.domainDirParam), this.domainName);
        if (!this.isWritableDirectory(domainFile)) {
            throw new CommandException(strings.get("InvalidDirectory", domainFile.getPath()));
        }
        this.setBackupDir(this.backupdir);
        this.prepareRequest();
        this.initializeLogger();
    }

    @Override
    protected int executeCommand() throws CommandException {
        try {
            ListManager mgr = new ListManager(this.request);
            logger.info(mgr.list());
        }
        catch (BackupWarningException bwe) {
            logger.info(bwe.getMessage());
        }
        catch (BackupException be) {
            throw new CommandException(be);
        }
        return 0;
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString(this);
    }
}

