/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment.annotation.context;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContextImpl;
import com.sun.enterprise.deployment.annotation.handlers.PostProcessor;
import com.sun.enterprise.deployment.types.HandlerChainContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.util.TypeUtil;
import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.impl.ComponentDefinition;
import org.glassfish.deployment.common.Descriptor;

public class EjbContext
extends ResourceContainerContextImpl {
    private WebServiceEndpoint endpoint;
    private Method[] methods;
    private boolean inherited;
    private ArrayList<PostProcessInfo> postProcessInfos = new ArrayList();

    public EjbContext(EjbDescriptor currentEjb, Class ejbClass) {
        super((Descriptor)((Object)currentEjb));
        this.componentClassName = currentEjb.getEjbClassName();
        ComponentDefinition cdef = new ComponentDefinition(ejbClass);
        this.methods = cdef.getMethods();
        Class superClass = ejbClass.getSuperclass();
        this.inherited = superClass != null && !Object.class.equals(superClass);
    }

    public EjbDescriptor getDescriptor() {
        return (EjbDescriptor)((Object)this.descriptor);
    }

    public void setDescriptor(EjbDescriptor currentEjb) {
        this.descriptor = (Descriptor)((Object)currentEjb);
    }

    public void setEndpoint(WebServiceEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    public WebServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Override
    public void endElement(ElementType type2, AnnotatedElement element) throws AnnotationProcessorException {
        if (ElementType.TYPE.equals((Object)type2)) {
            for (PostProcessInfo ppInfo : this.postProcessInfos) {
                ppInfo.postProcessor.postProcessAnnotation(ppInfo.ainfo, this);
            }
            this.getProcessingContext().popHandler();
        }
    }

    public Class getDeclaringClass(MethodDescriptor md) {
        Method method = md.getMethod(this.getDescriptor());
        Class<?> declaringClass = null;
        for (Method m : this.methods) {
            if (!TypeUtil.sameMethodSignature(m, method)) continue;
            declaringClass = m.getDeclaringClass();
        }
        return declaringClass;
    }

    public Method[] getComponentDefinitionMethods() {
        return this.methods;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public void addPostProcessInfo(AnnotationInfo ainfo, PostProcessor postProcessor) {
        PostProcessInfo ppInfo = new PostProcessInfo();
        ppInfo.ainfo = ainfo;
        ppInfo.postProcessor = postProcessor;
        this.postProcessInfos.add(ppInfo);
    }

    public ServiceReferenceContainer[] getServiceRefContainers(String implName) {
        return this.getDescriptor().getEjbBundleDescriptor().getEjbByClassName(implName);
    }

    @Override
    public HandlerChainContainer[] getHandlerChainContainers(boolean serviceSideHandlerChain, Class declaringClass) {
        if (serviceSideHandlerChain) {
            EjbDescriptor[] ejbs = this.getDescriptor().getEjbBundleDescriptor().getEjbByClassName(declaringClass.getName());
            ArrayList<WebServiceEndpoint> result = new ArrayList<WebServiceEndpoint>();
            for (EjbDescriptor ejb : ejbs) {
                result.addAll(this.getDescriptor().getEjbBundleDescriptor().getWebServices().getEndpointsImplementedBy(ejb));
            }
            return result.toArray(new HandlerChainContainer[result.size()]);
        }
        ArrayList<ServiceReferenceDescriptor> result = new ArrayList<ServiceReferenceDescriptor>();
        result.addAll(this.getDescriptor().getEjbBundleDescriptor().getEjbServiceReferenceDescriptors());
        return result.toArray(new HandlerChainContainer[result.size()]);
    }

    private static class PostProcessInfo {
        public AnnotationInfo ainfo;
        public PostProcessor postProcessor;

        private PostProcessInfo() {
        }
    }
}

