/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.EmbeddedInhabitantsParser;
import com.sun.enterprise.glassfish.bootstrap.GlassFishImpl;
import com.sun.enterprise.glassfish.bootstrap.JarUtil;
import com.sun.enterprise.glassfish.bootstrap.SingleHK2Factory;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.ContextDuplicatePostProcessor;
import com.sun.enterprise.module.bootstrap.Main;
import com.sun.enterprise.module.bootstrap.ModuleStartup;
import com.sun.enterprise.module.bootstrap.StartupContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.hk2.api.ServiceLocator;

public class StaticGlassFishRuntime
extends GlassFishRuntime {
    private Main main;
    private HashMap gfMap = new HashMap();
    private static Logger logger = Util.getLogger();
    private static final String autoDelete = "org.glassfish.embeddable.autoDelete";

    public StaticGlassFishRuntime(Main main) {
        this.main = main;
    }

    @Override
    public synchronized GlassFish newGlassFish(GlassFishProperties glassFishProperties) throws GlassFishException {
        try {
            Properties cloned = new Properties();
            cloned.putAll((Map<?, ?>)glassFishProperties.getProperties());
            final GlassFishProperties gfProps = new GlassFishProperties(cloned);
            this.setEnv(gfProps);
            StartupContext startupContext = new StartupContext(gfProps.getProperties());
            ModulesRegistry modulesRegistry = SingleHK2Factory.getInstance().createModulesRegistry();
            ServiceLocator serviceLocator = this.main.createServiceLocator(modulesRegistry, startupContext, Arrays.asList(new EmbeddedInhabitantsParser(), new ContextDuplicatePostProcessor()), null);
            ModuleStartup gfKernel = this.main.findStartupService(modulesRegistry, serviceLocator, null, startupContext);
            GlassFishImpl gfImpl = new GlassFishImpl(gfKernel, serviceLocator, gfProps.getProperties()){

                @Override
                public void dispose() throws GlassFishException {
                    try {
                        super.dispose();
                    }
                    finally {
                        File instanceRoot;
                        StaticGlassFishRuntime.this.gfMap.remove(gfProps.getInstanceRoot());
                        if ("true".equalsIgnoreCase(gfProps.getProperties().getProperty(StaticGlassFishRuntime.autoDelete)) && gfProps.getInstanceRoot() != null && (instanceRoot = new File(gfProps.getInstanceRoot())).exists()) {
                            Util.deleteRecursive(instanceRoot);
                        }
                    }
                }
            };
            this.gfMap.put(gfProps.getInstanceRoot(), gfImpl);
            return gfImpl;
        }
        catch (GlassFishException e) {
            throw e;
        }
        catch (Exception e) {
            throw new GlassFishException(e);
        }
    }

    @Override
    public synchronized void shutdown() throws GlassFishException {
        for (Object gf : this.gfMap.values()) {
            try {
                ((GlassFish)gf).dispose();
            }
            catch (IllegalStateException illegalStateException) {}
        }
        this.gfMap.clear();
        try {
            StaticGlassFishRuntime.shutdownInternal();
        }
        catch (GlassFishException ex) {
            logger.log(Level.WARNING, "NCLS-BOOTSTRAP-00039", ex.getMessage());
        }
    }

    private void setEnv(GlassFishProperties gfProps) throws Exception {
        String instanceRootValue = gfProps.getInstanceRoot();
        if (instanceRootValue == null) {
            instanceRootValue = this.createTempInstanceRoot(gfProps);
            gfProps.setInstanceRoot(instanceRootValue);
        }
        File instanceRoot = new File(instanceRootValue);
        System.setProperty("com.sun.aas.instanceRoot", instanceRoot.getAbsolutePath());
        System.setProperty("com.sun.aas.instanceRootURI", instanceRoot.toURI().toString());
        String installRootValue = System.getProperty("org.glassfish.embeddable.installRoot");
        if (installRootValue == null) {
            installRootValue = instanceRoot.getAbsolutePath();
            JarUtil.extractRars(installRootValue);
        }
        JarUtil.setEnv(installRootValue);
        File installRoot = new File(installRootValue);
        System.setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        System.setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
        gfProps.getProperties().setProperty("com.sun.aas.installRoot", installRoot.getAbsolutePath());
        gfProps.getProperties().setProperty("com.sun.aas.installRootURI", installRoot.toURI().toString());
    }

    private String createTempInstanceRoot(GlassFishProperties gfProps) throws Exception {
        String tmpDir = gfProps.getProperties().getProperty("glassfish.embedded.tmpdir", System.getProperty("glassfish.embedded.tmpdir"));
        if (tmpDir == null) {
            tmpDir = System.getProperty("java.io.tmpdir");
        } else {
            new File(tmpDir).mkdirs();
        }
        File instanceRoot = File.createTempFile("gfembed", "tmp", new File(tmpDir));
        if (!instanceRoot.delete() || !instanceRoot.mkdir()) {
            throw new Exception("cannot create directory: " + instanceRoot.getAbsolutePath());
        }
        try {
            String configFileURI;
            String[] configFiles = new String[]{"config/keyfile", "config/server.policy", "config/cacerts.jks", "config/keystore.jks", "config/login.conf", "config/logging.properties", "config/loggingToFile.properties", "config/admin-keyfile", "org/glassfish/web/embed/default-web.xml", "org/glassfish/embed/domain.xml"};
            File instanceConfigDir = new File(instanceRoot, "config");
            instanceConfigDir.mkdirs();
            new File(instanceRoot, "docroot").mkdirs();
            ClassLoader cl = this.getClass().getClassLoader();
            for (String configFile : configFiles) {
                URL url = cl.getResource(configFile);
                if (url == null) continue;
                StaticGlassFishRuntime.copy(url, new File(instanceConfigDir, configFile.substring(configFile.lastIndexOf(47) + 1)), false);
            }
            URL brandingUrl = cl.getResource("config/branding/glassfish-version.properties");
            if (brandingUrl != null) {
                StaticGlassFishRuntime.copy(brandingUrl, new File(instanceConfigDir, "branding" + File.separator + "glassfish-version.properties"), false);
            }
            if ((configFileURI = gfProps.getConfigFileURI()) != null) {
                StaticGlassFishRuntime.copy(URI.create(configFileURI).toURL(), new File(instanceConfigDir, "domain.xml"), true);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String autoDeleteVal = gfProps.getProperties().getProperty(autoDelete, "true");
        gfProps.getProperties().setProperty(autoDelete, autoDeleteVal);
        return instanceRoot.getAbsolutePath();
    }

    public static void copy(URL u, File destFile, boolean overwrite) {
        if (u == null || destFile == null) {
            return;
        }
        try {
            if (!(destFile.exists() && !overwrite || destFile.toURI().equals(u.toURI()))) {
                InputStream stream = u.openStream();
                destFile.getParentFile().mkdirs();
                Util.copy(stream, new FileOutputStream(destFile), stream.available());
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer("Copied " + u.toURI() + " to " + destFile.toURI());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

