/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.resource.deployer.AbstractConnectorResourceDeployer;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.glassfish.connectors.config.ResourceAdapterConfig;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.jvnet.hk2.annotations.Service;

@Service
@ResourceDeployerInfo(value=ResourceAdapterConfig.class)
@Singleton
public class ResourceAdapterConfigDeployer
extends AbstractConnectorResourceDeployer {
    @Inject
    private Provider<ConnectorRuntime> connectorRuntimeProvider;
    private static Logger _logger = LogDomains.getLogger(ResourceAdapterConfigDeployer.class, "javax.enterprise.resource.resourceadapter");

    @Override
    public synchronized void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
        this.deployResource(resource);
    }

    @Override
    public synchronized void deployResource(Object resource) throws Exception {
        ResourceAdapterConfig domainConfig = (ResourceAdapterConfig)resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = this.getConnectorRuntime();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Calling backend to add resource adapterConfig ", rarName);
        }
        crt.addResourceAdapterConfig(rarName, domainConfig);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Added resource adapterConfig in backend", rarName);
        }
    }

    private ConnectorRuntime getConnectorRuntime() {
        return this.connectorRuntimeProvider.get();
    }

    @Override
    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
        this.undeployResource(resource);
    }

    @Override
    public synchronized void undeployResource(Object resource) throws Exception {
        ResourceAdapterConfig domainConfig = (ResourceAdapterConfig)resource;
        String rarName = domainConfig.getResourceAdapterName();
        ConnectorRuntime crt = this.getConnectorRuntime();
        crt.deleteResourceAdapterConfig(rarName);
    }

    @Override
    public synchronized void redeployResource(Object resource) throws Exception {
        this.deployResource(resource);
    }

    @Override
    public boolean handles(Object resource) {
        boolean canHandle = false;
        if (resource instanceof ResourceAdapterConfig) {
            canHandle = true;
        }
        return canHandle;
    }

    @Override
    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    @Override
    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    @Override
    public synchronized void disableResource(Object resource) throws Exception {
    }

    @Override
    public synchronized void enableResource(Object resource) throws Exception {
    }
}

