/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.jdbc40;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.gjc.spi.ManagedConnectionFactoryImpl;
import com.sun.gjc.spi.ManagedConnectionImpl;
import com.sun.gjc.spi.base.ConnectionHolder;
import com.sun.logging.LogDomains;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Struct;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;

public class ConnectionHolder40
extends ConnectionHolder {
    private static final Logger _logger = LogDomains.getLogger(ConnectionHolder40.class, "javax.enterprise.resource.resourceadapter", ConnectionHolder.class.getClassLoader());
    protected static final StringManager localStrings = StringManager.getManager(ManagedConnectionFactoryImpl.class);
    protected Properties defaultClientInfo;
    protected boolean jdbc30Connection;

    public ConnectionHolder40(Connection con, ManagedConnectionImpl mc, ConnectionRequestInfo cxRequestInfo, boolean jdbc30Connection) {
        super(con, mc, cxRequestInfo);
        this.jdbc30Connection = jdbc30Connection;
        if (!jdbc30Connection) {
            this.init();
        }
    }

    protected void init() {
        block3: {
            try {
                if (this.isSupportClientInfo()) {
                    this.defaultClientInfo = this.getClientInfo();
                }
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINEST)) break block3;
                _logger.log(Level.FINEST, "jdbc.unable_to_get_client_info", e);
            }
        }
    }

    @Override
    public Clob createClob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createBlob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createSQLXML();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkValidity();
        return this.con.isValid(timeout);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        try {
            this.checkValidity();
        }
        catch (SQLException sqe) {
            SQLClientInfoException sce = new SQLClientInfoException();
            sce.setStackTrace(sqe.getStackTrace());
            throw sce;
        }
        this.con.setClientInfo(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        try {
            this.checkValidity();
        }
        catch (SQLException sqe) {
            SQLClientInfoException sce = new SQLClientInfoException();
            sce.setStackTrace(sqe.getStackTrace());
            throw sce;
        }
        this.con.setClientInfo(properties);
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkValidity();
        return this.con.getClientInfo(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkValidity();
        return this.con.getClientInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSupportClientInfo() {
        Boolean isSupportClientInfo = this.getManagedConnection().isClientInfoSupported();
        if (isSupportClientInfo != null) {
            return isSupportClientInfo;
        }
        ResultSet rs = null;
        try {
            rs = this.getManagedConnection().getCachedDatabaseMetaData().getClientInfoProperties();
            isSupportClientInfo = rs.next();
        }
        catch (Exception e) {
            isSupportClientInfo = false;
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "jdbc.unable_to_get_client_info", e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                _logger.log(Level.SEVERE, "Cannot close resultset!", e);
            }
        }
        this.getManagedConnection().setClientInfoSupported(isSupportClientInfo);
        return isSupportClientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createArrayOf(typeName, elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkValidity();
        this.jdbcPreInvoke();
        return this.con.createStruct(typeName, attributes);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkValidity();
        T result = null;
        if (iface.isInstance(this)) {
            result = iface.cast(this);
        } else if (iface.isInstance(this.con)) {
            Class[] listIntf = new Class[]{iface};
            result = this.getProxyObject(this.con, listIntf);
        } else {
            result = this.con.unwrap(iface);
            if (Connection.class.isInstance(result)) {
                Class[] listIntf = new Class[]{iface, Connection.class};
                result = this.getProxyObject(result, listIntf);
            }
        }
        return result;
    }

    private <T> T getProxyObject(final Object actualObject, Class<T>[] ifaces) throws SQLException {
        InvocationHandler ih;
        try {
            ih = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws SQLException, IllegalAccessException, InvocationTargetException {
                    if (method.getName().equals("close") && method.getParameterTypes().length == 0) {
                        if (_logger.isLoggable(Level.FINE)) {
                            String msg = localStrings.getString("jdbc.close_called_on_proxy_object", actualObject);
                            _logger.log(Level.FINE, msg);
                        }
                        ConnectionHolder40.this.close();
                        return null;
                    }
                    return method.invoke(actualObject, args);
                }
            };
        }
        catch (Exception e) {
            throw new SQLException(e.fillInStackTrace());
        }
        Object result = Proxy.newProxyInstance(actualObject.getClass().getClassLoader(), ifaces, ih);
        return (T)result;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkValidity();
        boolean result = iface.isInstance(this) ? true : this.con.isWrapperFor(iface);
        return result;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "jdbc.duplicate_close_connection", this);
            }
            return;
        }
        if (!this.jdbc30Connection) {
            try {
                this.checkValidity();
                if (this.isSupportClientInfo()) {
                    if (this.defaultClientInfo == null) {
                        this.setClientInfo(new Properties());
                    } else {
                        this.setClientInfo(this.defaultClientInfo);
                    }
                }
            }
            catch (Exception e) {
                _logger.log(Level.SEVERE, "jdbc.unable_to_set_client_info", e);
            }
        }
        super.close();
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        if (DataSourceObjectBuilder.isJDBC41()) {
            this.checkValidity();
            Class[] valueTypes = new Class[]{String.class};
            try {
                this.getMethodExecutor().invokeMethod(this.con, "setSchema", valueTypes, schema);
            }
            catch (ResourceException ex) {
                _logger.log(Level.SEVERE, "jdbc.ex_connection_holder", ex);
                throw new SQLException(ex);
            }
            return;
        }
        throw new UnsupportedOperationException("Operation not supported in this runtime.");
    }

    @Override
    public String getSchema() throws SQLException {
        if (DataSourceObjectBuilder.isJDBC41()) {
            this.checkValidity();
            try {
                return (String)this.getMethodExecutor().invokeMethod(this.con, "getSchema", null, new Object[0]);
            }
            catch (ResourceException ex) {
                _logger.log(Level.SEVERE, "jdbc.ex_connection_holder", ex);
                throw new SQLException(ex);
            }
        }
        throw new UnsupportedOperationException("Operation not supported in this runtime.");
    }

    @Override
    public void setNetworkTimeout(Executor executorObj, int milliseconds) throws SQLException {
        if (DataSourceObjectBuilder.isJDBC41()) {
            this.checkValidity();
            Class[] valueTypes = new Class[]{Executor.class, Integer.TYPE};
            try {
                this.getMethodExecutor().invokeMethod(this.con, "setNetworkTimeout", valueTypes, executorObj, milliseconds);
            }
            catch (ResourceException ex) {
                _logger.log(Level.SEVERE, "jdbc.ex_connection_holder", ex);
                throw new SQLException(ex);
            }
            return;
        }
        throw new UnsupportedOperationException("Operation not supported in this runtime.");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        if (DataSourceObjectBuilder.isJDBC41()) {
            this.checkValidity();
            try {
                return (Integer)this.getMethodExecutor().invokeMethod(this.con, "getNetworkTimeout", null, new Object[0]);
            }
            catch (ResourceException ex) {
                _logger.log(Level.SEVERE, "jdbc.ex_connection_holder", ex);
                throw new SQLException(ex);
            }
        }
        throw new UnsupportedOperationException("Operation not supported in this runtime.");
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        if (DataSourceObjectBuilder.isJDBC41()) {
            this.getManagedConnection().markForRemoval(true);
            this.getManagedConnection().setAborted(true);
            if (!this.getManagedConnection().isTransactionInProgress()) {
                this.close();
            }
        } else {
            throw new UnsupportedOperationException("Operation not supported in this runtime.");
        }
    }
}

