/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.ha.hazelcast.store;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import fish.payara.ha.hazelcast.store.HazelcastBackingStore;
import fish.payara.ha.hazelcast.store.HazelcastBackingStoreTransaction;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.io.Serializable;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreConfiguration;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.api.BackingStoreFactory;
import org.glassfish.ha.store.api.BackingStoreTransaction;
import org.jvnet.hk2.annotations.Service;

@Service(name="hazelcast-factory")
public class HazelcastBackingStoreFactory
implements BackingStoreFactory {
    private HazelcastInstance hazelcast = null;
    @Inject
    HazelcastCore core;

    @PostConstruct
    public void postConstruct() {
        this.hazelcast = this.core.getInstance();
    }

    @Override
    public <K extends Serializable, V extends Serializable> BackingStore<K, V> createBackingStore(BackingStoreConfiguration<K, V> bsc) throws BackingStoreException {
        if (!this.core.isEnabled()) {
            throw new BackingStoreException("Hazelcast is NOT Enabled please enable Hazelcast");
        }
        IMap storeMap = this.hazelcast.getMap(bsc.getStoreName());
        return new HazelcastBackingStore(storeMap, this, this.hazelcast.getLocalEndpoint().getUuid());
    }

    @Override
    public BackingStoreTransaction createBackingStoreTransaction() {
        return new HazelcastBackingStoreTransaction(this.hazelcast.newTransactionContext());
    }
}

