/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.jbatch.persistence.rdbms;

import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.spi.services.IBatchConfig;
import fish.payara.jbatch.persistence.rdbms.JBatchJDBCPersistenceManager;
import fish.payara.jbatch.persistence.rdbms.OracleJDBCConstants;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class OraclePersistenceManager
extends JBatchJDBCPersistenceManager
implements OracleJDBCConstants {
    private static final String CLASSNAME = OraclePersistenceManager.class.getName();
    private static final Logger logger = Logger.getLogger(CLASSNAME);
    private IBatchConfig batchConfig = null;
    protected Map<String, String> createOracleTableStrings;
    protected Map<String, String> createOracleIndexStrings;
    protected Map<String, String> oracleObjectNames;

    @Override
    protected Map<String, String> getSharedQueryMap(IBatchConfig batchConfig) throws SQLException {
        Map<String, String> result = super.getSharedQueryMap(batchConfig);
        result.put("MOST_RECENT_STEPS_FOR_JOB", "select A.* from " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " A inner join " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B on A.jobexecid = B.jobexecid where B.jobinstanceid = ? order by A.stepexecid desc");
        result.put("JOB_OPERATOR_GET_JOB_EXECUTION", "select A.jobexecid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.jobinstanceid, A.batchstatus, A.exitstatus, B.name from " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A inner join " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " B on A.jobinstanceid = B.jobinstanceid where jobexecid = ?");
        result.put("JOB_OPERATOR_GET_JOB_EXECUTIONS", "select A.jobexecid, A.jobinstanceid, A.createtime, A.starttime, A.endtime, A.updatetime, A.parameters, A.batchstatus, A.exitstatus, B.name from " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " A inner join " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " B ON A.jobinstanceid = B.jobinstanceid where A.jobinstanceid = ?");
        result.put("GET_JOB_STATUS_FROM_EXECUTIONS", "select A.obj from " + (String)this.tableNames.get("JOB_STATUS_TABLE_KEY") + " A inner join " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " B on A.id = B.jobinstanceid where B.jobexecid = ?");
        return result;
    }

    @Override
    public void init(IBatchConfig batchConfig) throws BatchContainerServiceException {
        logger.config("Entering CLASSNAME.init(), batchConfig =" + batchConfig);
        this.batchConfig = batchConfig;
        this.schema = batchConfig.getDatabaseConfigurationBean().getSchema();
        this.jndiName = batchConfig.getDatabaseConfigurationBean().getJndiName();
        if (this.jndiName == null || this.jndiName.equals("")) {
            throw new BatchContainerServiceException("JNDI name is not defined.");
        }
        try {
            InitialContext ctx = new InitialContext();
            this.dataSource = (DataSource)ctx.lookup(this.jndiName);
        }
        catch (NamingException e) {
            logger.severe("Lookup failed for JNDI name: " + this.jndiName + ".  One cause of this could be that the batch runtime is incorrectly configured to EE mode when it should be in SE mode.");
            throw new BatchContainerServiceException(e);
        }
        this.tableNames = this.getSharedTableMap(batchConfig);
        this.oracleObjectNames = this.getOracleObjectsMap(batchConfig);
        try {
            this.queryStrings = this.getSharedQueryMap(batchConfig);
        }
        catch (SQLException e1) {
            throw new BatchContainerServiceException(e1);
        }
        logger.config("JNDI name = " + this.jndiName);
        try {
            if (!this.isOracleSchemaValid()) {
                this.setDefaultSchema();
            }
            this.checkOracleTables();
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw new BatchContainerServiceException(e);
        }
        logger.config("Exiting CLASSNAME.init()");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isOracleSchemaValid() throws SQLException {
        ResultSet rs;
        Connection conn;
        boolean result;
        block7: {
            boolean bl;
            block6: {
                logger.entering(CLASSNAME, "isOracleSchemaValid");
                result = false;
                conn = null;
                DatabaseMetaData dbmd = null;
                rs = null;
                try {
                    conn = this.getConnectionToDefaultSchema();
                    dbmd = conn.getMetaData();
                    rs = dbmd.getSchemas();
                    while (rs.next()) {
                        String schemaname = rs.getString("TABLE_SCHEM");
                        if (!this.schema.equalsIgnoreCase(schemaname)) continue;
                        logger.exiting(CLASSNAME, "isSchemaValid", true);
                        bl = true;
                        break block6;
                    }
                    break block7;
                }
                catch (SQLException e) {
                    try {
                        logger.severe(e.getLocalizedMessage());
                        throw e;
                    }
                    catch (Throwable throwable) {
                        this.cleanupConnection(conn, rs, null);
                        throw throwable;
                    }
                }
            }
            this.cleanupConnection(conn, rs, null);
            return bl;
        }
        this.cleanupConnection(conn, rs, null);
        logger.exiting(CLASSNAME, "isOracleSchemaValid", false);
        return result;
    }

    private void checkOracleTables() throws SQLException {
        this.createOracleTableStrings = this.setOracleTableMap(this.batchConfig);
        this.createOracleIndexStrings = this.setOracleIndexMap(this.batchConfig);
        logger.entering(CLASSNAME, "checkOracleTables");
        this.createOracleTableNotExists((String)this.tableNames.get("CHECKPOINT_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_CHECKPOINTDATA"));
        if (!this.checkOracleIndexExists(this.oracleObjectNames.get("chk_index"), "chk_index", (String)this.tableNames.get("CHECKPOINT_TABLE_KEY"))) {
            this.executeStatement(this.createOracleIndexStrings.get("CREATE_CHECKPOINTDATA_INDEX"));
        }
        this.createOracleTableNotExists((String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_JOBINSTANCEDATA"));
        this.createOracleSequenceNotExists(this.oracleObjectNames.get("JOBINSTANCE_SEQ"), this.createOracleTableStrings.get("CREATE_JOBINSTANCEDATA_SEQ"));
        this.createOracleTriggerNotExists(this.oracleObjectNames.get("JOBINSTANCE_TRG"), this.createOracleTableStrings.get("CREATE_JOBINSTANCEDATA_TRG"), "JOBINSTANCEDATA_TRG", (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY"));
        this.createOracleTableNotExists((String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_EXECUTIONINSTANCEDATA"));
        this.createOracleSequenceNotExists(this.oracleObjectNames.get("EXECUTIONINSTANCE_SEQ"), this.createOracleTableStrings.get("CREATE_EXECUTIONINSTANCEDATA_SEQ"));
        this.createOracleTriggerNotExists(this.oracleObjectNames.get("EXECUTIONINSTANCE_TRG"), this.createOracleTableStrings.get("CREATE_EXECUTIONINSTANCEDATA_TRG"), "EXECUTIONINSTANCEDATA_TRG", (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY"));
        this.createOracleTableNotExists((String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_STEPINSTANCEDATA"));
        this.createOracleSequenceNotExists(this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_SEQ"), this.createOracleTableStrings.get("CREATE_STEPINSTANCEDATA_SEQ"));
        this.createOracleTriggerNotExists(this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_TRG"), this.createOracleTableStrings.get("CREATE_STEPINSTANCEDATA_TRG"), "STEPEXECUTIONINSTANCEDATA_TRG", (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY"));
        this.createOracleTableNotExists((String)this.tableNames.get("JOB_STATUS_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_JOBSTATUS"));
        this.createOracleTableNotExists((String)this.tableNames.get("STEP_STATUS_TABLE_KEY"), this.createOracleTableStrings.get("CREATE_TABLE_STEPSTATUS"));
        logger.exiting(CLASSNAME, "checkOracleTables");
    }

    protected void createOracleTableNotExists(String tableName, String createTableStatement) throws SQLException {
        logger.entering(CLASSNAME, "createOracleTableNotExists", new Object[]{tableName, createTableStatement});
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            stmt = conn.createStatement(1004, 1007);
            String query = "SELECT lower(owner),lower(table_name) FROM all_tables where lower(owner) =  '" + this.schema.toLowerCase() + "'" + " and lower(table_name)= " + "'" + tableName.toLowerCase() + "'";
            rs = stmt.executeQuery(query);
            int rowcount = this.getTableRowCount(rs);
            if (rowcount == 0 && !rs.next()) {
                logger.log(Level.INFO, tableName + " table does not exists. Trying to create it.");
                ps = conn.prepareStatement(createTableStatement);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            logger.severe(e.getLocalizedMessage());
            throw e;
        }
        finally {
            this.cleanupConnection(conn, ps);
        }
        logger.exiting(CLASSNAME, "createOracleTableNotExists");
    }

    public void createOracleSequenceNotExists(String sequencename, String seqstmt) throws SQLException {
        logger.entering(CLASSNAME, "createOracleSequenceNotExists");
        Connection conn = null;
        boolean seqexists = false;
        ResultSet results = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            Statement stmt = conn.createStatement();
            String query = "select lower(sequence_name) from user_sequences where lower(sequence_name)='" + sequencename.toLowerCase() + "'";
            results = stmt.executeQuery(query);
            if (results.next()) {
                seqexists = true;
            }
            if (!seqexists) {
                ps = conn.prepareStatement(seqstmt);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, results, ps);
                throw throwable;
            }
        }
        this.cleanupConnection(conn, results, ps);
        logger.exiting(CLASSNAME, "createOracleSequenceNotExists");
    }

    public void createOracleTriggerNotExists(String triggername, String trgstmt, String defaultTriggername, String tablename) throws SQLException {
        logger.entering(CLASSNAME, "createOracleTableNotExists", new Object[]{triggername, trgstmt, defaultTriggername, tablename});
        Connection conn = null;
        boolean triggerexists = false;
        ResultSet results = null;
        Statement ps = null;
        try {
            conn = this.getConnection();
            Statement stmt = conn.createStatement();
            String query = "select lower(trigger_name) from user_triggers  where lower(table_owner)='" + this.schema.toLowerCase() + "'" + " and lower(trigger_name) in (" + "'" + triggername.toLowerCase() + "'," + "'" + defaultTriggername.toLowerCase() + "')" + " and lower(table_name)='" + tablename.toLowerCase() + "'";
            results = stmt.executeQuery(query);
            if (results.next()) {
                triggerexists = true;
            }
            if (!triggerexists) {
                ps = conn.createStatement();
                ps.executeUpdate(trgstmt);
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, results, null);
                throw throwable;
            }
        }
        this.cleanupConnection(conn, results, null);
        logger.exiting(CLASSNAME, "createOracleTriggerNotExists");
    }

    public boolean checkOracleIndexExists(String indexname, String defaultIndexname, String tablename) throws SQLException {
        logger.entering(CLASSNAME, "createOracleIndexNotExists", new Object[]{indexname, defaultIndexname, tablename});
        Connection conn = null;
        boolean indexexists = false;
        ResultSet results = null;
        try {
            conn = this.getConnection();
            Statement stmt = conn.createStatement();
            String query = "select lower(index_name) from user_indexes where lower(table_owner)='" + this.schema.toLowerCase() + "'" + " and lower(index_name) in (" + "'" + indexname.toLowerCase() + "'," + "'" + defaultIndexname.toLowerCase() + "')" + " and lower(table_name)='" + tablename.toLowerCase() + "'";
            results = stmt.executeQuery(query);
            if (results.next()) {
                indexexists = true;
            }
        }
        catch (SQLException e) {
            try {
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                this.cleanupConnection(conn, results, null);
                throw throwable;
            }
        }
        this.cleanupConnection(conn, results, null);
        logger.exiting(CLASSNAME, "createOracleIndexNotExists");
        return indexexists;
    }

    protected Map<String, String> setOracleTableMap(IBatchConfig batchConfig) {
        String prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        String suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        this.createOracleTableStrings = new HashMap<String, String>();
        this.createOracleTableStrings.put("CREATE_TABLE_CHECKPOINTDATA", "CREATE TABLE " + (String)this.tableNames.get("CHECKPOINT_TABLE_KEY") + "(id VARCHAR(512),obj BLOB)");
        this.createOracleTableStrings.put("CREATE_TABLE_JOBINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid NUMBER(19,0) PRIMARY KEY,name VARCHAR2(512), apptag VARCHAR(512))");
        this.createOracleTableStrings.put("CREATE_JOBINSTANCEDATA_SEQ", "CREATE SEQUENCE " + this.oracleObjectNames.get("JOBINSTANCE_SEQ"));
        this.createOracleTableStrings.put("CREATE_JOBINSTANCEDATA_TRG", "CREATE OR REPLACE TRIGGER " + this.oracleObjectNames.get("JOBINSTANCE_TRG") + " BEFORE INSERT ON " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " FOR EACH ROW BEGIN SELECT " + this.oracleObjectNames.get("JOBINSTANCE_SEQ") + ".nextval INTO :new.jobinstanceid FROM dual; END;");
        this.createOracleTableStrings.put("CREATE_TABLE_EXECUTIONINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid NUMBER(19,0) PRIMARY KEY, jobinstanceid NUMBER(19,0), " + "createtime TIMESTAMP, starttime TIMESTAMP, endtime TIMESTAMP, updatetime TIMESTAMP, " + "parameters BLOB, batchstatus VARCHAR2(512), exitstatus VARCHAR2(512)," + "CONSTRAINT " + prefix + "JOBINST_JOBEXEC_FK" + suffix + " FOREIGN KEY (jobinstanceid) REFERENCES " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + "(jobinstanceid))");
        this.createOracleTableStrings.put("CREATE_EXECUTIONINSTANCEDATA_SEQ", "CREATE SEQUENCE " + this.oracleObjectNames.get("EXECUTIONINSTANCE_SEQ"));
        this.createOracleTableStrings.put("CREATE_EXECUTIONINSTANCEDATA_TRG", "CREATE OR REPLACE TRIGGER " + this.oracleObjectNames.get("EXECUTIONINSTANCE_TRG") + " BEFORE INSERT ON " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + " FOR EACH ROW BEGIN SELECT " + this.oracleObjectNames.get("EXECUTIONINSTANCE_SEQ") + ".nextval INTO :new.jobexecid FROM dual;END;");
        this.createOracleTableStrings.put("CREATE_TABLE_STEPINSTANCEDATA", "CREATE TABLE " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + "(stepexecid NUMBER(19,0) PRIMARY KEY, jobexecid NUMBER(19,0)," + "batchstatus VARCHAR2(512), exitstatus VARCHAR2(512), stepname VARCHAR(512), " + "readcount NUMBER(11, 0), writecount NUMBER(11, 0), commitcount NUMBER(11, 0),rollbackcount NUMBER(11, 0), " + "readskipcount NUMBER(11, 0), processskipcount NUMBER(11, 0), filtercount NUMBER(11, 0), writeskipcount NUMBER(11, 0), " + "startTime TIMESTAMP, endTime TIMESTAMP, persistentData BLOB, " + "CONSTRAINT " + prefix + "JOBEXEC_STEPEXEC_FK" + suffix + " FOREIGN KEY (jobexecid) REFERENCES " + (String)this.tableNames.get("EXECUTION_INSTANCE_TABLE_KEY") + "(jobexecid))");
        this.createOracleTableStrings.put("CREATE_STEPINSTANCEDATA_SEQ", "CREATE SEQUENCE " + this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_SEQ"));
        this.createOracleTableStrings.put("CREATE_STEPINSTANCEDATA_TRG", "CREATE OR REPLACE TRIGGER " + this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_TRG") + " BEFORE INSERT ON " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " FOR EACH ROW BEGIN SELECT " + this.oracleObjectNames.get("STEPEXECUTIONINSTANCE_SEQ") + ".nextval INTO :new.stepexecid FROM dual;END;");
        this.createOracleTableStrings.put("CREATE_TABLE_JOBSTATUS", "CREATE TABLE " + (String)this.tableNames.get("JOB_STATUS_TABLE_KEY") + "(id NUMBER(19,0) PRIMARY KEY," + "obj BLOB," + "CONSTRAINT " + prefix + "JOBSTATUS_JOBINST_FK" + suffix + " FOREIGN KEY (id) REFERENCES " + (String)this.tableNames.get("JOB_INSTANCE_TABLE_KEY") + " (jobinstanceid) ON DELETE CASCADE)");
        this.createOracleTableStrings.put("CREATE_TABLE_STEPSTATUS", "CREATE TABLE " + (String)this.tableNames.get("STEP_STATUS_TABLE_KEY") + "(id NUMBER(19,0) PRIMARY KEY," + "obj BLOB," + "CONSTRAINT " + prefix + "STEPSTATUS_STEPEXEC_FK" + suffix + " FOREIGN KEY (id) REFERENCES " + (String)this.tableNames.get("STEP_EXECUTION_INSTANCE_TABLE_KEY") + " (stepexecid) ON DELETE CASCADE)");
        return this.createOracleTableStrings;
    }

    protected Map<String, String> setOracleIndexMap(IBatchConfig batchConfig) {
        this.createOracleIndexStrings = new HashMap<String, String>();
        this.createOracleIndexStrings.put("CREATE_CHECKPOINTDATA_INDEX", "create index " + this.oracleObjectNames.get("chk_index") + " on " + (String)this.tableNames.get("CHECKPOINT_TABLE_KEY") + "(id)");
        return this.createOracleIndexStrings;
    }

    protected Map<String, String> getOracleObjectsMap(IBatchConfig batchConfig) {
        String prefix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.prefix", "");
        String suffix = batchConfig.getConfigProperties().getProperty("payara.jbatch.table.suffix", "");
        HashMap<String, String> result = new HashMap<String, String>(7);
        result.put("JOBINSTANCE_SEQ", prefix + "JOBINSTANCE_SEQ" + suffix);
        result.put("EXECUTIONINSTANCE_SEQ", prefix + "EXECUTIONINSTANCE_SEQ" + suffix);
        result.put("STEPEXECUTIONINSTANCE_SEQ", prefix + "STEPEXECUTIONINSTANCE_SEQ" + suffix);
        result.put("JOBINSTANCE_TRG", prefix + "JOBINSTANCE_TRG" + suffix);
        result.put("EXECUTIONINSTANCE_TRG", prefix + "EXECUTIONINSTANCE_TRG" + suffix);
        result.put("STEPEXECUTIONINSTANCE_TRG", prefix + "STEPEXECUTIONINSTANCE_TRG" + suffix);
        result.put("chk_index", prefix + "chk_index" + suffix);
        return result;
    }
}

