/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.glassfish.bootstrap.StaticGlassFishRuntime;
import fish.payara.micro.BootstrapException;
import fish.payara.micro.GAVConvertor;
import fish.payara.micro.PayaraMicroRuntime;
import fish.payara.micro.PortBinder;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import fish.payara.nucleus.hazelcast.MulticastConfiguration;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.phonehome.PhoneHomeCore;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class PayaraMicro {
    private static final Logger logger = Logger.getLogger("PayaraMicro");
    private static PayaraMicro instance;
    private String hzMulticastGroup;
    private int hzPort = Integer.MIN_VALUE;
    private int hzStartPort = Integer.MIN_VALUE;
    private String hzClusterName;
    private String hzClusterPassword;
    private int httpPort = Integer.MIN_VALUE;
    private int sslPort = Integer.MIN_VALUE;
    private int maxHttpThreads = Integer.MIN_VALUE;
    private int minHttpThreads = Integer.MIN_VALUE;
    private String instanceName = UUID.randomUUID().toString();
    private File rootDir;
    private File deploymentRoot;
    private File alternateDomainXML;
    private URI alternateHZConfigFile;
    private List<File> deployments;
    private GlassFish gf;
    private PayaraMicroRuntime runtime;
    private boolean noCluster = false;
    private boolean autoBindHttp = false;
    private boolean autoBindSsl = false;
    private boolean liteMember = false;
    private boolean generateLogo = false;
    private boolean logToFile = false;
    private boolean enableAccessLog = false;
    private boolean enableAccessLogFormat = false;
    private boolean logPropertiesFile = false;
    private String userLogPropertiesFile = "";
    private int autoBindRange = 5;
    private String bootImage = "boot.txt";
    private String applicationDomainXml;
    private boolean enableHealthCheck = false;
    private boolean disablePhoneHome = false;
    private List<String> GAVs;
    private File uberJar;
    private Properties userSystemProperties;
    private Map<String, URL> deploymentURLsMap;
    private List<URL> repositoryURLs;
    private final String defaultMavenRepository = "https://repo.maven.apache.org/maven2/";
    private final short defaultHttpPort = (short)8080;
    private final short defaultHttpsPort = (short)8181;
    private String loggingPropertiesFileName = "logging.properties";
    private String loggingToFilePropertiesFileName = "loggingToFile.properties";
    private String domainFileName = "domain.xml";
    private String userLogFile = "payara-server%u.log";
    private String userAccessLogDirectory = "";
    private String accessLogFormat = "%client.name% %auth-user-name% %datetime% %request% %status% %response.length%";
    private String userPropertiesFileName = "";

    public static void main(String[] args) throws BootstrapException {
        PayaraMicro main = PayaraMicro.getInstance();
        main.scanArgs(args);
        if (main.getUberJar() != null) {
            main.packageUberJar();
        } else {
            main.bootStrap();
        }
    }

    public static PayaraMicro getInstance() {
        return PayaraMicro.getInstance(true);
    }

    public static PayaraMicroRuntime bootstrap() throws BootstrapException {
        return PayaraMicro.getInstance().bootStrap();
    }

    public static PayaraMicro getInstance(boolean create) {
        if (instance == null && create) {
            instance = new PayaraMicro();
        }
        return instance;
    }

    public String getClusterMulticastGroup() {
        return this.hzMulticastGroup;
    }

    public PayaraMicro setClusterMulticastGroup(String hzMulticastGroup) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.hzMulticastGroup = hzMulticastGroup;
        return this;
    }

    public PayaraMicro setLogoFile(String filePath) {
        this.bootImage = filePath;
        return this;
    }

    public PayaraMicro setPrintLogo(boolean generate) {
        this.generateLogo = generate;
        return this;
    }

    public PayaraMicro setUserLogFile(String fileName) {
        File file = new File(fileName);
        if (file.isDirectory()) {
            if (!file.exists() || !file.canWrite()) {
                logger.log(Level.SEVERE, "{0} is not a valid directory for storing logs as it must exist and be writable", file.getAbsolutePath());
                throw new IllegalArgumentException();
            }
            this.userLogFile = file.getAbsolutePath() + File.separator + this.userLogFile;
        } else {
            this.userLogFile = fileName;
        }
        this.logToFile = true;
        return this;
    }

    public PayaraMicro setLogPropertiesFile(File fileName) {
        System.setProperty("java.util.logging.config.file", fileName.getAbsolutePath());
        this.logPropertiesFile = true;
        this.userLogPropertiesFile = fileName.getAbsolutePath();
        this.userPropertiesFileName = fileName.getName();
        return this;
    }

    public void setAccessLogDir(String filePath) {
        this.userAccessLogDirectory = filePath;
        this.enableAccessLog = true;
    }

    public void setAccessLogFormat(String format) {
        this.accessLogFormat = format;
        this.enableAccessLogFormat = true;
    }

    public int getClusterPort() {
        return this.hzPort;
    }

    public PayaraMicro setClusterPort(int hzPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.hzPort = hzPort;
        return this;
    }

    public int getClusterStartPort() {
        return this.hzStartPort;
    }

    public PayaraMicro setClusterStartPort(int hzStartPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.hzStartPort = hzStartPort;
        return this;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public PayaraMicro setHttpPort(int httpPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.httpPort = httpPort;
        return this;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public File getUberJar() {
        return this.uberJar;
    }

    public PayaraMicro setSslPort(int sslPort) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.sslPort = sslPort;
        return this;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public PayaraMicro setInstanceName(String instanceName) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.instanceName = instanceName;
        return this;
    }

    public File getDeploymentDir() {
        return this.deploymentRoot;
    }

    public PayaraMicro setDeploymentDir(File deploymentRoot) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.deploymentRoot = deploymentRoot;
        return this;
    }

    public File getAlternateDomainXML() {
        return this.alternateDomainXML;
    }

    public PayaraMicro setApplicationDomainXML(String domainXml) {
        this.applicationDomainXml = domainXml;
        return this;
    }

    public PayaraMicro setAlternateDomainXML(File alternateDomainXML) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.alternateDomainXML = alternateDomainXML;
        return this;
    }

    public PayaraMicro addDeployment(String pathToWar) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        File file = new File(pathToWar);
        return this.addDeploymentFile(file);
    }

    public PayaraMicro addDeploymentFile(File file) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        if (this.deployments == null) {
            this.deployments = new LinkedList<File>();
        }
        this.deployments.add(file);
        return this;
    }

    public PayaraMicro addDeployFromGAV(String GAV) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        if (this.GAVs == null) {
            this.GAVs = new LinkedList<String>();
        }
        this.GAVs.add(GAV);
        if (this.GAVs != null) {
            try {
                this.getGAVURLs();
            }
            catch (GlassFishException ex) {
                Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return this;
    }

    public PayaraMicro addRepoUrl(String ... URLs) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        for (String url : URLs) {
            try {
                if (!url.endsWith("/")) {
                    this.repositoryURLs.add(new URL(url + "/"));
                    continue;
                }
                this.repositoryURLs.add(new URL(url));
            }
            catch (MalformedURLException ex) {
                logger.log(Level.SEVERE, "{0} is not a valid URL and will be ignored", url);
            }
        }
        return this;
    }

    public boolean isNoCluster() {
        return this.noCluster;
    }

    public PayaraMicro setNoCluster(boolean noCluster) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.noCluster = noCluster;
        return this;
    }

    public boolean isLite() {
        return this.liteMember;
    }

    public PayaraMicro setLite(boolean liteMember) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.liteMember = liteMember;
        return this;
    }

    public int getMaxHttpThreads() {
        return this.maxHttpThreads;
    }

    public PayaraMicro setMaxHttpThreads(int maxHttpThreads) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.maxHttpThreads = maxHttpThreads;
        return this;
    }

    public int getMinHttpThreads() {
        return this.minHttpThreads;
    }

    public PayaraMicro setMinHttpThreads(int minHttpThreads) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.minHttpThreads = minHttpThreads;
        return this;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public PayaraMicro setRootDir(File rootDir) {
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, setting attributes has no effect");
        }
        this.rootDir = rootDir;
        return this;
    }

    public boolean getHttpAutoBind() {
        return this.autoBindHttp;
    }

    public PayaraMicro setHttpAutoBind(boolean httpAutoBind) {
        this.autoBindHttp = httpAutoBind;
        return this;
    }

    public boolean getSslAutoBind() {
        return this.autoBindSsl;
    }

    public PayaraMicro setSslAutoBind(boolean sslAutoBind) {
        this.autoBindSsl = sslAutoBind;
        return this;
    }

    public int getAutoBindRange() {
        return this.autoBindRange;
    }

    public PayaraMicro setAutoBindRange(int autoBindRange) {
        this.autoBindRange = autoBindRange;
        return this;
    }

    public String getHzClusterName() {
        return this.hzClusterName;
    }

    public PayaraMicro setHzClusterName(String hzClusterName) {
        this.hzClusterName = hzClusterName;
        return this;
    }

    public String getHzClusterPassword() {
        return this.hzClusterPassword;
    }

    public PayaraMicro setHzClusterPassword(String hzClusterPassword) {
        this.hzClusterPassword = hzClusterPassword;
        return this;
    }

    public PayaraMicroRuntime bootStrap() throws BootstrapException {
        long start = System.currentTimeMillis();
        if (this.isRunning()) {
            throw new IllegalStateException("Payara Micro is already running, calling bootstrap now is meaningless");
        }
        MulticastConfiguration mc = new MulticastConfiguration();
        mc.setMemberName(this.instanceName);
        if (this.hzPort > Integer.MIN_VALUE) {
            mc.setMulticastPort(this.hzPort);
        }
        if (this.hzStartPort > Integer.MIN_VALUE) {
            mc.setStartPort(this.hzStartPort);
        }
        if (this.hzMulticastGroup != null) {
            mc.setMulticastGroup(this.hzMulticastGroup);
        }
        if (this.alternateHZConfigFile != null) {
            mc.setAlternateConfiguration(this.alternateHZConfigFile);
        }
        mc.setLite(this.liteMember);
        if (this.hzClusterName != null) {
            mc.setClusterGroupName(this.hzClusterName);
        }
        if (this.hzClusterPassword != null) {
            mc.setClusterGroupPassword(this.hzClusterPassword);
        }
        HazelcastCore.setMulticastOverride(mc);
        this.setSystemProperties();
        BootstrapProperties bprops = new BootstrapProperties();
        PortBinder portBinder = new PortBinder();
        if (this.disablePhoneHome) {
            PhoneHomeCore.setOverrideEnabled(false);
        }
        try {
            File loggingProperties;
            GlassFishRuntime gfruntime = GlassFishRuntime.bootstrap(bprops, Thread.currentThread().getContextClassLoader());
            GlassFishProperties gfproperties = new GlassFishProperties();
            if (this.httpPort != Integer.MIN_VALUE) {
                if (this.autoBindHttp) {
                    this.logPortPrecedenceWarnings(false);
                    try {
                        gfproperties.setPort("http-listener", portBinder.findAvailablePort(this.httpPort, this.autoBindRange));
                    }
                    catch (BindException ex) {
                        logger.log(Level.SEVERE, "No available port found in range: " + this.httpPort + " - " + (this.httpPort + this.autoBindRange), ex);
                        throw new GlassFishException("Could not bind HTTP port");
                    }
                } else {
                    this.logPortPrecedenceWarnings(false);
                    gfproperties.setPort("http-listener", this.httpPort);
                }
            } else if (this.autoBindHttp) {
                this.logPortPrecedenceWarnings(false);
                try {
                    gfproperties.setPort("http-listener", portBinder.findAvailablePort(8080, this.autoBindRange));
                }
                catch (BindException ex) {
                    logger.log(Level.SEVERE, "No available port found in range: 8080 - " + (8080 + this.autoBindRange), ex);
                    throw new GlassFishException("Could not bind HTTP port");
                }
            }
            if (this.sslPort != Integer.MIN_VALUE) {
                if (this.autoBindSsl) {
                    this.logPortPrecedenceWarnings(true);
                    try {
                        gfproperties.setPort("https-listener", portBinder.findAvailablePort(this.sslPort, this.autoBindRange));
                    }
                    catch (BindException ex) {
                        logger.log(Level.SEVERE, "No available port found in range: " + this.sslPort + " - " + (this.sslPort + this.autoBindRange), ex);
                        throw new GlassFishException("Could not bind SSL port");
                    }
                } else {
                    this.logPortPrecedenceWarnings(true);
                    gfproperties.setPort("https-listener", this.sslPort);
                }
            } else if (this.autoBindSsl) {
                this.logPortPrecedenceWarnings(true);
                try {
                    gfproperties.setPort("https-listener", portBinder.findAvailablePort(8181, this.autoBindRange));
                }
                catch (BindException ex) {
                    logger.log(Level.SEVERE, "No available port found in range: 8181 - " + (8181 + this.autoBindRange), ex);
                    throw new GlassFishException("Could not bind SSL port");
                }
            }
            if (this.alternateDomainXML != null) {
                gfproperties.setConfigFileReadOnly(false);
                gfproperties.setConfigFileURI("file:///" + this.alternateDomainXML.getAbsolutePath().replace('\\', '/'));
            } else if (this.applicationDomainXml != null) {
                gfproperties.setConfigFileURI(Thread.currentThread().getContextClassLoader().getResource(this.applicationDomainXml).toExternalForm());
            } else if (this.noCluster) {
                gfproperties.setConfigFileURI(Thread.currentThread().getContextClassLoader().getResource("microdomain-nocluster.xml").toExternalForm());
            } else {
                gfproperties.setConfigFileURI(Thread.currentThread().getContextClassLoader().getResource("microdomain.xml").toExternalForm());
            }
            if (this.rootDir != null) {
                gfproperties.setInstanceRoot(this.rootDir.getAbsolutePath());
                File configFile = new File(this.rootDir.getAbsolutePath() + File.separator + "config" + File.separator + "domain.xml");
                if (!configFile.exists()) {
                    this.installFiles(gfproperties);
                } else if (this.alternateDomainXML == null) {
                    String absolutePath = this.rootDir.getAbsolutePath();
                    absolutePath = absolutePath.replace('\\', '/');
                    gfproperties.setConfigFileURI("file:///" + absolutePath + "/config/domain.xml");
                    gfproperties.setConfigFileReadOnly(false);
                }
            }
            if (this.maxHttpThreads != Integer.MIN_VALUE) {
                gfproperties.setProperty("embedded-glassfish-config.server.thread-pools.thread-pool.http-thread-pool.max-thread-pool-size", Integer.toString(this.maxHttpThreads));
            }
            if (this.minHttpThreads != Integer.MIN_VALUE) {
                gfproperties.setProperty("embedded-glassfish-config.server.thread-pools.thread-pool.http-thread-pool.min-thread-pool-size", Integer.toString(this.minHttpThreads));
            }
            if (this.enableAccessLog) {
                gfproperties.setProperty("embedded-glassfish-config.server.http-service.access-logging-enabled", "true");
                gfproperties.setProperty("embedded-glassfish-config.server.http-service.virtual-server.server.access-logging-enabled", "true");
                gfproperties.setProperty("embedded-glassfish-config.server.http-service.virtual-server.server.access-log", this.userAccessLogDirectory);
                if (this.enableAccessLogFormat) {
                    gfproperties.setProperty("embedded-glassfish-config.server.http-service.access-log.format", this.accessLogFormat);
                }
            }
            this.gf = gfruntime.newGlassFish(gfproperties);
            String instanceRootStr = System.getProperty("com.sun.aas.instanceRoot");
            File configDir = new File(instanceRootStr, "config");
            File loggingToFileProperties = new File(configDir.getAbsolutePath(), this.loggingToFilePropertiesFileName);
            Path domainFile = Paths.get(configDir.getAbsolutePath() + File.separator + this.domainFileName, new String[0]);
            if (this.enableAccessLog) {
                Charset charset = StandardCharsets.UTF_8;
                try {
                    String content = new String(Files.readAllBytes(domainFile), charset);
                    content = content.replaceAll("access-logging-enabled=\"false\"", "access-logging-enabled=\"true\"");
                    content = content.replace("access-log=\"\"", "access-log=\"" + this.userAccessLogDirectory + "\"");
                    if (this.enableAccessLogFormat) {
                        content = content.replace("access-log format=\"%client.name% %auth-user-name% %datetime% %request% %status% %response.length%\"", "access-log format=\"" + this.accessLogFormat + "\"");
                    }
                    Files.write(domainFile, content.getBytes(charset), new OpenOption[0]);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if (this.logToFile) {
                this.loggingPropertiesFileName = this.loggingToFilePropertiesFileName;
                Properties props = new Properties();
                String propsFilename = loggingToFileProperties.getAbsolutePath();
                try {
                    FileInputStream configStream = new FileInputStream(propsFilename);
                    props.load(configStream);
                    configStream.close();
                    props.setProperty("java.util.logging.FileHandler.pattern", this.userLogFile);
                    FileOutputStream output = new FileOutputStream(propsFilename);
                    props.store(output, "Payara Micro Logging Properties File");
                    output.close();
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            if ((loggingProperties = new File(configDir.getAbsolutePath(), this.loggingPropertiesFileName)).exists() && loggingProperties.canRead() && loggingProperties.isFile()) {
                if (System.getProperty("java.util.logging.config.file") == null) {
                    System.setProperty("java.util.logging.config.file", loggingProperties.getAbsolutePath());
                }
                try {
                    LogManager.getLogManager().readConfiguration();
                }
                catch (IOException | SecurityException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
            this.configureSecurity();
            this.gf.start();
            this.runtime = new PayaraMicroRuntime(this.instanceName, this.gf, gfruntime);
            this.deployAll();
            if (this.generateLogo) {
                this.generateLogo();
            }
            if (this.enableHealthCheck) {
                HealthCheckService healthCheckService = this.gf.getService(HealthCheckService.class);
                healthCheckService.setEnabled(this.enableHealthCheck);
            }
            long end = System.currentTimeMillis();
            logger.info(Version.getFullVersion() + " ready in " + (end - start) + " (ms)");
            return this.runtime;
        }
        catch (GlassFishException ex) {
            throw new BootstrapException(ex.getMessage(), ex);
        }
    }

    public PayaraMicroRuntime getRuntime() throws IllegalStateException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Payara Micro is not running");
        }
        return this.runtime;
    }

    public void shutdown() throws BootstrapException {
        if (!this.isRunning()) {
            throw new IllegalStateException("Payara Micro is not running");
        }
        this.runtime.shutdown();
        this.runtime = null;
    }

    private PayaraMicro() {
        try {
            this.repositoryURLs = new LinkedList<URL>();
            this.repositoryURLs.add(new URL("https://repo.maven.apache.org/maven2/"));
            this.setArgumentsFromSystemProperties();
            this.addShutdownHook();
        }
        catch (MalformedURLException ex) {
            logger.log(Level.SEVERE, "{0} is not a valid default URL", "https://repo.maven.apache.org/maven2/");
        }
    }

    private void scanArgs(String[] args) {
        block100: for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (null == arg) continue;
            switch (arg) {
                case "--port": {
                    String httpPortS = args[i + 1];
                    try {
                        this.httpPort = Integer.parseInt(httpPortS);
                        if (this.httpPort < 1 || this.httpPort > 65535) {
                            throw new NumberFormatException("Not a valid tcp port");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid http port number", httpPortS);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--sslPort": {
                    String httpPortS = args[i + 1];
                    try {
                        this.sslPort = Integer.parseInt(httpPortS);
                        if (this.sslPort < 1 || this.sslPort > 65535) {
                            throw new NumberFormatException("Not a valid tcp port");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid ssl port number and will be ignored", httpPortS);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--version": {
                    String deployments = System.getProperty("user.dir");
                    System.err.println("deployments " + deployments);
                    try {
                        Properties props = new Properties();
                        InputStream input = PayaraMicro.class.getResourceAsStream("/config/branding/glassfish-version.properties");
                        props.load(input);
                        StringBuilder output = new StringBuilder();
                        if (!props.getProperty("product_name").isEmpty()) {
                            output.append(props.getProperty("product_name") + " ");
                        }
                        if (!props.getProperty("major_version").isEmpty()) {
                            output.append(props.getProperty("major_version") + ".");
                        }
                        if (!props.getProperty("minor_version").isEmpty()) {
                            output.append(props.getProperty("minor_version") + ".");
                        }
                        if (!props.getProperty("update_version").isEmpty()) {
                            output.append(props.getProperty("update_version") + ".");
                        }
                        if (!props.getProperty("payara_version").isEmpty()) {
                            output.append(props.getProperty("payara_version"));
                        }
                        if (!props.getProperty("payara_update_version").isEmpty()) {
                            output.append("." + props.getProperty("payara_update_version"));
                        }
                        if (!props.getProperty("build_id").isEmpty()) {
                            output.append(" Build Number " + props.getProperty("build_id"));
                        }
                        System.err.println(output.toString());
                    }
                    catch (FileNotFoundException ex) {
                        Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IOException io) {
                        Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, io);
                    }
                    System.exit(1);
                    continue block100;
                }
                case "--maxHttpThreads": {
                    String threads = args[i + 1];
                    try {
                        this.maxHttpThreads = Integer.parseInt(threads);
                        if (this.maxHttpThreads < 2) {
                            throw new NumberFormatException("Maximum Threads must be 2 or greater");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid maximum threads number and will be ignored", threads);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--minHttpThreads": {
                    String threads = args[i + 1];
                    try {
                        this.minHttpThreads = Integer.parseInt(threads);
                        if (this.minHttpThreads < 0) {
                            throw new NumberFormatException("Minimum Threads must be zero or greater");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid minimum threads number and will be ignored", threads);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--mcAddress": {
                    this.hzMulticastGroup = args[i + 1];
                    ++i;
                    continue block100;
                }
                case "--clusterName": {
                    this.hzClusterName = args[i + 1];
                    ++i;
                    continue block100;
                }
                case "--clusterPassword": {
                    this.hzClusterPassword = args[i + 1];
                    ++i;
                    continue block100;
                }
                case "--mcPort": {
                    String httpPortS = args[i + 1];
                    try {
                        this.hzPort = Integer.parseInt(httpPortS);
                        if (this.hzPort < 1 || this.hzPort > 65535) {
                            throw new NumberFormatException("Not a valid tcp port");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid multicast port number and will be ignored", httpPortS);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--startPort": {
                    String startPort = args[i + 1];
                    try {
                        this.hzStartPort = Integer.parseInt(startPort);
                        if (this.hzStartPort < 1 || this.hzStartPort > 65535) {
                            throw new NumberFormatException("Not a valid tcp port");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid port number and will be ignored", startPort);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--name": {
                    this.instanceName = args[i + 1];
                    ++i;
                    continue block100;
                }
                case "--deploymentDir": {
                    this.deploymentRoot = new File(args[i + 1]);
                    if (!this.deploymentRoot.exists() || !this.deploymentRoot.isDirectory()) {
                        logger.log(Level.SEVERE, "{0} is not a valid deployment directory and will be ignored", args[i + 1]);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--rootDir": {
                    this.rootDir = new File(args[i + 1]);
                    if (!this.rootDir.exists() || !this.rootDir.isDirectory()) {
                        logger.log(Level.SEVERE, "{0} is not a valid root directory and will be ignored", args[i + 1]);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--deploy": {
                    File deployment = new File(args[i + 1]);
                    if (!deployment.exists() || !deployment.canRead()) {
                        logger.log(Level.SEVERE, "{0} is not a valid deployment path and will be ignored", deployment.getAbsolutePath());
                    } else {
                        if (this.deployments == null) {
                            this.deployments = new LinkedList<File>();
                        }
                        this.deployments.add(deployment);
                    }
                    ++i;
                    continue block100;
                }
                case "--domainConfig": {
                    this.alternateDomainXML = new File(args[i + 1]);
                    if (!(this.alternateDomainXML.exists() && this.alternateDomainXML.isFile() && this.alternateDomainXML.canRead() && this.alternateDomainXML.getAbsolutePath().endsWith(".xml"))) {
                        logger.log(Level.SEVERE, "{0} is not a valid path to an xml file and will be ignored", this.alternateDomainXML.getAbsolutePath());
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--noCluster": {
                    this.noCluster = true;
                    continue block100;
                }
                case "--lite": {
                    this.liteMember = true;
                    continue block100;
                }
                case "--hzConfigFile": {
                    File testFile = new File(args[i + 1]);
                    if (!(testFile.exists() && testFile.isFile() && testFile.canRead() && testFile.getAbsolutePath().endsWith(".xml"))) {
                        logger.log(Level.SEVERE, "{0} is not a valid path to an xml file and will be ignored", testFile.getAbsolutePath());
                        throw new IllegalArgumentException();
                    }
                    this.alternateHZConfigFile = testFile.toURI();
                    ++i;
                    continue block100;
                }
                case "--autoBindHttp": {
                    this.autoBindHttp = true;
                    continue block100;
                }
                case "--autoBindSsl": {
                    this.autoBindSsl = true;
                    continue block100;
                }
                case "--autoBindRange": {
                    String autoBindRangeString = args[i + 1];
                    try {
                        this.autoBindRange = Integer.parseInt(autoBindRangeString);
                        if (this.autoBindRange < 1) {
                            throw new NumberFormatException("Not a valid auto bind range");
                        }
                    }
                    catch (NumberFormatException nfe) {
                        logger.log(Level.SEVERE, "{0} is not a valid auto bind range number", autoBindRangeString);
                        throw new IllegalArgumentException();
                    }
                    ++i;
                    continue block100;
                }
                case "--enableHealthCheck": {
                    String enableHealthCheckString = args[i + 1];
                    this.enableHealthCheck = Boolean.valueOf(enableHealthCheckString);
                    continue block100;
                }
                case "--deployFromGAV": {
                    if (this.GAVs == null) {
                        this.GAVs = new LinkedList<String>();
                    }
                    this.GAVs.add(args[i + 1]);
                    ++i;
                    continue block100;
                }
                case "--additionalRepository": {
                    try {
                        if (!args[i + 1].endsWith("/")) {
                            this.repositoryURLs.add(new URL(args[i + 1] + "/"));
                        } else {
                            this.repositoryURLs.add(new URL(args[i + 1]));
                        }
                    }
                    catch (MalformedURLException ex) {
                        logger.log(Level.SEVERE, "{0} is not a valid URL and will be ignored", args[i + 1]);
                    }
                    ++i;
                    continue block100;
                }
                case "--outputUberJar": {
                    this.uberJar = new File(args[i + 1]);
                    ++i;
                    continue block100;
                }
                case "--systemProperties": {
                    File propertiesFile = new File(args[i + 1]);
                    this.userSystemProperties = new Properties();
                    try (FileReader reader = new FileReader(propertiesFile);){
                        this.userSystemProperties.load(reader);
                        Enumeration<?> names = this.userSystemProperties.propertyNames();
                        while (names.hasMoreElements()) {
                            String name = (String)names.nextElement();
                            System.setProperty(name, this.userSystemProperties.getProperty(name));
                        }
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "{0} is not a valid properties file", propertiesFile.getAbsolutePath());
                        throw new IllegalArgumentException(e);
                    }
                    if (propertiesFile.isFile() || propertiesFile.canRead()) continue block100;
                    logger.log(Level.SEVERE, "{0} is not a valid properties file", propertiesFile.getAbsolutePath());
                    throw new IllegalArgumentException();
                }
                case "--disablePhoneHome": {
                    this.disablePhoneHome = true;
                    continue block100;
                }
                case "--help": {
                    System.err.println("Usage:\n  --noCluster  Disables clustering\n  --port <http-port-number> sets the http port\n  --sslPort <ssl-port-number> sets the https port number\n  --mcAddress <muticast-address> sets the cluster multicast group\n  --mcPort <multicast-port-number> sets the cluster multicast port\n  --clusterName <cluster-name> sets the Cluster Group Name\n  --clusterPassword <cluster-password> sets the Cluster Group Password\n  --startPort <cluster-start-port-number> sets the cluster start port number\n  --name <instance-name> sets the instance name\n  --rootDir <directory-path> Sets the root configuration directory and saves the configuration across restarts\n  --deploymentDir <directory-path> if set to a valid directory all war files in this directory will be deployed\n  --deploy <file-path> specifies a war file to deploy\n  --domainConfig <file-path> overrides the complete server configuration with an alternative domain.xml file\n  --minHttpThreads <threads-number> the minimum number of threads in the HTTP thread pool\n  --maxHttpThreads <threads-number> the maximum number of threads in the HTTP thread pool\n  --hzConfigFile <file-path> the hazelcast-configuration file to use to override the in-built hazelcast cluster configuration\n  --autoBindHttp sets autobinding of the http port to a non-bound port\n  --autoBindSsl sets autobinding of the https port to a non-bound port\n  --autoBindRange <number-of-ports> sets the maximum number of ports to look at for port autobinding\n  --lite sets the micro container to lite mode which means it clusters with other Payara Micro instances but does not store any cluster data\n  --enableHealthCheck <boolean> enables/disables Health Check Service (disabled by default).\n  --logo reveal the #BadAssFish\n  --deployFromGAV <list-of-artefacts> specifies a comma separated groupId,artifactId,versionNumber of an artefact to deploy from a repository\n  --additionalRepository <repo-url> specifies an additional repository to search for deployable artefacts in\n  --outputUberJar <file-path> packages up an uber jar at the specified path based on the command line arguments and exits\n  --systemProperties <file-path> Reads system properties from a file\n  --disablePhoneHome Disables sending of usage tracking information\n  --version Displays the version information\n  --logToFile <file-path> outputs all the Log entries to a user defined file\n  --logProperties <file-path> Allows user to set their own logging properties file\n  --accessLog <directory-path> Sets user defined directory path for the access log\n  --accessLogFormat Sets user defined log format for the access log\n  --help Shows this message and exits\n");
                    System.exit(1);
                    continue block100;
                }
                case "--logToFile": {
                    this.setUserLogFile(args[i + 1]);
                    continue block100;
                }
                case "--accessLog": {
                    File file = new File(args[i + 1]);
                    if (!(file.exists() && file.isDirectory() && file.canWrite())) {
                        logger.log(Level.SEVERE, "{0} is not a valid directory for storing access logs as it must exist and be writable", file.getAbsolutePath());
                        throw new IllegalArgumentException();
                    }
                    this.setAccessLogDir(file.getAbsolutePath());
                    continue block100;
                }
                case "--accessLogFormat": {
                    this.setAccessLogFormat(args[i + 1]);
                    continue block100;
                }
                case "--logProperties": {
                    File logPropertiesFile = new File(args[i + 1]);
                    if (!logPropertiesFile.exists() || !logPropertiesFile.canRead() || logPropertiesFile.isDirectory()) {
                        logger.log(Level.SEVERE, "{0} is not a valid properties file path", logPropertiesFile.getAbsolutePath());
                        throw new IllegalArgumentException();
                    }
                    this.setLogPropertiesFile(logPropertiesFile);
                    continue block100;
                }
                case "--logo": {
                    this.generateLogo = true;
                }
            }
        }
    }

    private void deployAll() throws GlassFishException {
        URL url;
        int deploymentCount = 0;
        Deployer deployer = this.gf.getDeployer();
        if (this.deployments != null) {
            for (File file : this.deployments) {
                if (file.exists() && file.canRead()) {
                    deployer.deploy(file, "--availabilityenabled=true");
                    ++deploymentCount;
                    continue;
                }
                logger.log(Level.WARNING, "{0} is not a valid deployment", file.getAbsolutePath());
            }
        }
        if (this.deploymentRoot != null) {
            for (File war : this.deploymentRoot.listFiles()) {
                String warPath = war.getAbsolutePath();
                if (!war.isFile() || !war.canRead() || !warPath.endsWith(".war") && !warPath.endsWith(".ear") && !warPath.endsWith(".jar") && !warPath.endsWith(".rar")) continue;
                deployer.deploy(war, "--availabilityenabled=true");
                ++deploymentCount;
            }
        }
        if (this.GAVs != null) {
            this.getGAVURLs();
            if (!this.deploymentURLsMap.isEmpty()) {
                for (Map.Entry entry : this.deploymentURLsMap.entrySet()) {
                    try {
                        URI artefactURI = ((URL)entry.getValue()).toURI();
                        deployer.deploy(artefactURI, "--availabilityenabled", "true", "--contextroot", (String)entry.getKey());
                        ++deploymentCount;
                    }
                    catch (URISyntaxException ex) {
                        logger.log(Level.WARNING, "{0} could not be converted to a URI, artefact will be skipped", ((URL)entry.getValue()).toString());
                    }
                }
            }
        }
        if ((url = this.getClass().getClassLoader().getResource("META-INF/deploy")) != null) {
            String string = "";
            try {
                HashSet<String> entriesToDeploy = new HashSet<String>();
                JarURLConnection urlcon = (JarURLConnection)url.openConnection();
                JarFile jFile = urlcon.getJarFile();
                Enumeration<JarEntry> entries = jFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String string2 = entry.getName();
                    if (entry.isDirectory() || entry.getName().endsWith(".properties") || entry.getName().endsWith(".xml") || !entry.getName().startsWith("META-INF/deploy")) continue;
                    entriesToDeploy.add(entry.getName());
                }
                for (String entry : entriesToDeploy) {
                    File file = new File(entry);
                    String contextRoot = file.getName();
                    if (contextRoot.endsWith(".ear") || contextRoot.endsWith(".war") || contextRoot.endsWith(".jar") || contextRoot.endsWith(".rar")) {
                        contextRoot = contextRoot.substring(0, contextRoot.length() - 4);
                    }
                    if (contextRoot.equals("ROOT")) {
                        contextRoot = "/";
                    }
                    deployer.deploy(this.getClass().getClassLoader().getResourceAsStream(entry), "--availabilityenabled", "true", "--contextroot", contextRoot, "--name", file.getName());
                    ++deploymentCount;
                }
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "Could not deploy jar entry {0}", string);
            }
        } else {
            logger.info("No META-INF/deploy directory");
        }
        logger.log(Level.INFO, "Deployed {0} archives", deploymentCount);
    }

    private void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread("GlassFish Shutdown Hook"){

            @Override
            public void run() {
                try {
                    if (PayaraMicro.this.gf != null) {
                        PayaraMicro.this.gf.stop();
                        PayaraMicro.this.gf.dispose();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installFiles(GlassFishProperties gfproperties) {
        String[] configFiles;
        File configDir = new File(this.rootDir.getAbsolutePath(), "config");
        BufferedReader bufferedReader = null;
        new File(this.rootDir.getAbsolutePath(), "docroot").mkdirs();
        configDir.mkdirs();
        if (this.logPropertiesFile) {
            File userLogPropsFile = new File(configDir.getAbsolutePath() + File.separator + this.userPropertiesFileName);
            try {
                if (userLogPropsFile.exists()) {
                    userLogPropsFile.delete();
                } else {
                    userLogPropsFile.createNewFile();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            try {
                PrintWriter writer = new PrintWriter(userLogPropsFile.getAbsoluteFile());
                writer.print("");
                writer.close();
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            try {
                String sCurrentLine;
                bufferedReader = new BufferedReader(new FileReader(this.userLogPropertiesFile));
                FileWriter fileWriter = new FileWriter(userLogPropsFile.getAbsoluteFile());
                BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
                while ((sCurrentLine = bufferedReader.readLine()) != null) {
                    bufferedWriter.append(sCurrentLine);
                    bufferedWriter.newLine();
                }
                bufferedWriter.close();
            }
            catch (FileNotFoundException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException ex) {
                        logger.log(Level.SEVERE, null, ex);
                    }
                }
            }
            configFiles = new String[]{"config/keyfile", "config/server.policy", "config/cacerts.jks", "config/keystore.jks", "config/login.conf", "config/logging.properties", "config/loggingToFile.properties", "config/admin-keyfile", "config/" + this.userPropertiesFileName, "config/default-web.xml", "org/glassfish/embed/domain.xml"};
        } else {
            configFiles = new String[]{"config/keyfile", "config/server.policy", "config/cacerts.jks", "config/keystore.jks", "config/login.conf", "config/logging.properties", "config/loggingToFile.properties", "config/admin-keyfile", "config/default-web.xml", "org/glassfish/embed/domain.xml"};
        }
        ClassLoader cl = this.getClass().getClassLoader();
        for (String configFile : configFiles) {
            URL url = cl.getResource(configFile);
            if (url == null) continue;
            StaticGlassFishRuntime.copy(url, new File(configDir.getAbsoluteFile(), configFile.substring(configFile.lastIndexOf(47) + 1)), false);
        }
        URL brandingUrl = cl.getResource("config/branding/glassfish-version.properties");
        if (brandingUrl != null) {
            StaticGlassFishRuntime.copy(brandingUrl, new File(configDir.getAbsolutePath(), "branding/glassfish-version.properties"), false);
        }
        String configFileURI = gfproperties.getConfigFileURI();
        try {
            StaticGlassFishRuntime.copy(URI.create(configFileURI).toURL(), new File(configDir.getAbsolutePath(), "domain.xml"), true);
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void setSystemProperties() {
        try {
            Properties embeddedBootProperties = new Properties();
            ClassLoader loader = this.getClass().getClassLoader();
            embeddedBootProperties.load(loader.getResourceAsStream("payara-boot.properties"));
            for (Object key : embeddedBootProperties.keySet()) {
                String keyStr = (String)key;
                if (System.getProperty(keyStr) != null) continue;
                System.setProperty(keyStr, embeddedBootProperties.getProperty(keyStr));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    boolean isRunning() {
        try {
            return this.gf != null && this.gf.getStatus() == GlassFish.Status.STARTED;
        }
        catch (GlassFishException ex) {
            return false;
        }
    }

    void generateLogo() {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.bootImage);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) != -1) {
                System.err.write(buffer, 0, length);
                System.err.flush();
            }
        }
        catch (IOException | NullPointerException ex) {
            Logger.getLogger(PayaraMicro.class.getName()).log(Level.WARNING, "Problems displaying Boot Image", ex);
        }
    }

    private void getGAVURLs() throws GlassFishException {
        GAVConvertor gavConvertor = new GAVConvertor();
        for (String gav : this.GAVs) {
            Map.Entry<String, URL> artefactMapEntry = gavConvertor.getArtefactMapEntry(gav, this.repositoryURLs);
            if (this.deploymentURLsMap == null) {
                this.deploymentURLsMap = new LinkedHashMap<String, URL>();
            }
            this.deploymentURLsMap.put(artefactMapEntry.getKey(), artefactMapEntry.getValue());
        }
    }

    private void logPortPrecedenceWarnings(boolean HTTPS) {
        if (HTTPS) {
            File configFile;
            if (this.alternateDomainXML != null) {
                if (this.sslPort != Integer.MIN_VALUE) {
                    if (this.autoBindSsl) {
                        logger.log(Level.INFO, "Overriding HTTPS port value set in {0} and auto-binding against " + this.sslPort, this.alternateDomainXML.getAbsolutePath());
                    } else {
                        logger.log(Level.INFO, "Overriding HTTPS port value set in {0} with " + this.sslPort, this.alternateDomainXML.getAbsolutePath());
                    }
                } else if (this.autoBindSsl) {
                    logger.log(Level.INFO, "Overriding HTTPS port value set in {0} and auto-binding against 8181", this.alternateDomainXML.getAbsolutePath());
                } else {
                    logger.log(Level.INFO, "Overriding HTTPS port value set in {0} with 8181", this.alternateDomainXML.getAbsolutePath());
                }
            }
            if (this.rootDir != null && (configFile = new File(this.rootDir.getAbsolutePath() + File.separator + "config" + File.separator + "domain.xml")).exists()) {
                if (this.sslPort != Integer.MIN_VALUE) {
                    if (this.autoBindSsl) {
                        logger.log(Level.INFO, "Overriding HTTPS port value set in {0} and auto-binding against " + this.sslPort, configFile.getAbsolutePath());
                    } else {
                        logger.log(Level.INFO, "Overriding HTTPS port value set in {0} with " + this.sslPort, configFile.getAbsolutePath());
                    }
                } else if (this.autoBindSsl) {
                    logger.log(Level.INFO, "Overriding HTTPS port value set in {0} and auto-binding against 8181", configFile.getAbsolutePath());
                } else {
                    logger.log(Level.INFO, "Overriding HTTPS port value set in {0} with default value of 8181", configFile.getAbsolutePath());
                }
            }
        } else {
            File configFile;
            if (this.alternateDomainXML != null) {
                if (this.httpPort != Integer.MIN_VALUE) {
                    if (this.autoBindHttp) {
                        logger.log(Level.INFO, "Overriding HTTP port value set in {0} and auto-binding against " + this.httpPort, this.alternateDomainXML.getAbsolutePath());
                    } else {
                        logger.log(Level.INFO, "Overriding HTTP port value set in {0} with " + this.httpPort, this.alternateDomainXML.getAbsolutePath());
                    }
                } else if (this.autoBindHttp) {
                    logger.log(Level.INFO, "Overriding HTTP port value set in {0} and auto-binding against 8080", this.alternateDomainXML.getAbsolutePath());
                } else {
                    logger.log(Level.INFO, "Overriding HTTP port value set in {0} with default value of 8080", this.alternateDomainXML.getAbsolutePath());
                }
            }
            if (this.rootDir != null && (configFile = new File(this.rootDir.getAbsolutePath() + File.separator + "config" + File.separator + "domain.xml")).exists()) {
                if (this.httpPort != Integer.MIN_VALUE) {
                    if (this.autoBindHttp) {
                        logger.log(Level.INFO, "Overriding HTTP port value set in {0} and auto-binding against " + this.httpPort, configFile.getAbsolutePath());
                    } else {
                        logger.log(Level.INFO, "Overriding HTTP port value set in {0} with " + this.httpPort, configFile.getAbsolutePath());
                    }
                } else if (this.autoBindHttp) {
                    logger.log(Level.INFO, "Overriding HTTP port value set in {0} and auto-binding against 8080", configFile.getAbsolutePath());
                } else {
                    logger.log(Level.INFO, "Overriding HTTP port value set in {0} with default value of 8080", configFile.getAbsolutePath());
                }
            }
        }
    }

    private void setArgumentsFromSystemProperties() {
        String name;
        String alternateHZConfigFileStr;
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("META-INF/deploy/payaramicro.properties");){
            if (is != null) {
                Properties props = new Properties();
                props.load(is);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "", ex);
        }
        String alternateDomainXMLStr = System.getProperty("payaramicro.domainConfig");
        if (alternateDomainXMLStr != null && !alternateDomainXMLStr.isEmpty()) {
            this.applicationDomainXml = alternateDomainXMLStr;
        }
        if ((alternateHZConfigFileStr = System.getProperty("payaramicro.hzConfigFile")) != null && !alternateHZConfigFileStr.isEmpty()) {
            try {
                this.alternateHZConfigFile = Thread.currentThread().getContextClassLoader().getResource(alternateHZConfigFileStr).toURI();
            }
            catch (URISyntaxException ex) {
                logger.log(Level.WARNING, "payaramicro.hzConfigFile has invalid URI syntax and will be ignored", ex);
                this.alternateHZConfigFile = null;
            }
        }
        this.autoBindHttp = Boolean.getBoolean("payaramicro.autoBindHttp");
        this.autoBindRange = Integer.getInteger("payaramicro.autoBindRange", 5);
        this.autoBindSsl = Boolean.getBoolean("payaramicro.autoBindSsl");
        this.generateLogo = Boolean.getBoolean("payaramicro.logo");
        this.logToFile = Boolean.getBoolean("payaramicro.logToFile");
        this.enableAccessLog = Boolean.getBoolean("payaramicro.enableAccessLog");
        this.enableAccessLogFormat = Boolean.getBoolean("payaramicro.enableAccessLogFormat");
        this.logPropertiesFile = Boolean.getBoolean("payaramicro.logPropertiesFile");
        this.enableHealthCheck = Boolean.getBoolean("payaramicro.enableHealthCheck");
        this.httpPort = Integer.getInteger("payaramicro.port", Integer.MIN_VALUE);
        this.hzMulticastGroup = System.getProperty("payaramicro.mcAddress");
        this.hzPort = Integer.getInteger("payaramicro.mcPort", Integer.MIN_VALUE);
        this.hzStartPort = Integer.getInteger("payaramicro.startPort", Integer.MIN_VALUE);
        this.hzClusterName = System.getProperty("payaramicro.clusterName");
        this.hzClusterPassword = System.getProperty("payaramicro.clusterPassword");
        this.liteMember = Boolean.getBoolean("payaramicro.lite");
        this.maxHttpThreads = Integer.getInteger("payaramicro.maxHttpThreads", Integer.MIN_VALUE);
        this.minHttpThreads = Integer.getInteger("payaramicro.minHttpThreads", Integer.MIN_VALUE);
        this.noCluster = Boolean.getBoolean("payaramicro.noCluster");
        this.disablePhoneHome = Boolean.getBoolean("payaramicro.disablePhoneHome");
        String rootDirFileStr = System.getProperty("payaramicro.rootDir");
        if (rootDirFileStr != null && !rootDirFileStr.isEmpty()) {
            this.rootDir = new File(rootDirFileStr);
        }
        if ((name = System.getProperty("payaramicro.name")) != null && !name.isEmpty()) {
            this.instanceName = name;
        }
    }

    private void packageUberJar() {
        long start = System.currentTimeMillis();
        logger.info("Building Uber Jar... " + this.uberJar);
        try (JarOutputStream jos = new JarOutputStream(new FileOutputStream(this.uberJar));){
            byte[] buffer;
            Throwable throwable;
            String name;
            int bytesRead;
            byte[] buffer2;
            URL url = this.getClass().getClassLoader().getResource("payara-boot.properties");
            JarURLConnection urlcon = (JarURLConnection)url.openConnection();
            JarFile jFile = urlcon.getJarFile();
            Enumeration<JarEntry> entries = jFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                jos.putNextEntry(new JarEntry(entry.getName()));
                Object is = jFile.getInputStream(entry);
                if (entry.toString().contains("config/logging.properties") && this.logPropertiesFile) {
                    is = new FileInputStream(new File(this.userLogPropertiesFile));
                }
                byte[] byArray = new byte[4096];
                int bytesRead2 = 0;
                while ((bytesRead2 = ((InputStream)is).read(byArray)) != -1) {
                    jos.write(byArray, 0, bytesRead2);
                }
                ((InputStream)is).close();
                jos.flush();
                jos.closeEntry();
            }
            JarEntry deploymentDir = new JarEntry("META-INF/deploy/");
            jos.putNextEntry(deploymentDir);
            jos.flush();
            jos.closeEntry();
            if (this.deployments != null) {
                for (File file : this.deployments) {
                    JarEntry deploymentEntry = new JarEntry("META-INF/deploy/" + file.getName());
                    jos.putNextEntry(deploymentEntry);
                    try {
                        FileInputStream fis = new FileInputStream(file);
                        Throwable throwable2 = null;
                        try {
                            byte[] buffer22 = new byte[4096];
                            int bytesRead3 = 0;
                            while ((bytesRead3 = fis.read(buffer22)) != -1) {
                                jos.write(buffer22, 0, bytesRead3);
                            }
                            jos.flush();
                            jos.closeEntry();
                        }
                        catch (Throwable buffer22) {
                            throwable2 = buffer22;
                            throw buffer22;
                        }
                        finally {
                            if (fis == null) continue;
                            if (throwable2 != null) {
                                try {
                                    fis.close();
                                }
                                catch (Throwable buffer22) {
                                    throwable2.addSuppressed(buffer22);
                                }
                                continue;
                            }
                            fis.close();
                        }
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "Error adding deployment " + file.getAbsolutePath() + " to the Uber Jar Skipping...", ioe);
                    }
                }
            }
            if (this.deploymentRoot != null) {
                for (File deployment : this.deploymentRoot.listFiles()) {
                    if (!deployment.isFile()) continue;
                    JarEntry deploymentEntry = new JarEntry("META-INF/deploy/" + deployment.getName());
                    jos.putNextEntry(deploymentEntry);
                    try (FileInputStream fis = new FileInputStream(deployment);){
                        buffer2 = new byte[4096];
                        bytesRead = 0;
                        while ((bytesRead = fis.read(buffer2)) != -1) {
                            jos.write(buffer2, 0, bytesRead);
                        }
                        jos.flush();
                        jos.closeEntry();
                    }
                    catch (IOException ioe) {
                        logger.log(Level.WARNING, "Error adding deployment " + deployment.getAbsolutePath() + " to the Uber Jar Skipping...", ioe);
                    }
                }
            }
            if (this.GAVs != null) {
                try {
                    this.getGAVURLs();
                    for (Map.Entry entry : this.deploymentURLsMap.entrySet()) {
                        URL deployment = (URL)entry.getValue();
                        name = (String)entry.getKey();
                        try {
                            InputStream is = deployment.openStream();
                            Throwable ioe = null;
                            try {
                                JarEntry deploymentEntry = new JarEntry("META-INF/deploy/" + name);
                                jos.putNextEntry(deploymentEntry);
                                buffer2 = new byte[4096];
                                bytesRead = 0;
                                while ((bytesRead = is.read(buffer2)) != -1) {
                                    jos.write(buffer2, 0, bytesRead);
                                }
                                jos.flush();
                                jos.closeEntry();
                            }
                            catch (Throwable deploymentEntry) {
                                ioe = deploymentEntry;
                                throw deploymentEntry;
                            }
                            finally {
                                if (is == null) continue;
                                if (ioe != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable deploymentEntry) {
                                        ioe.addSuppressed(deploymentEntry);
                                    }
                                    continue;
                                }
                                is.close();
                            }
                        }
                        catch (IOException ioe) {
                            logger.log(Level.WARNING, "Error adding deployment " + name + " to the Uber Jar Skipping...", ioe);
                        }
                    }
                }
                catch (GlassFishException ex) {
                    logger.log(Level.SEVERE, "Unable to process maven deployment units", ex);
                }
            }
            JarEntry je = new JarEntry("META-INF/deploy/payaramicro.properties");
            jos.putNextEntry(je);
            Properties properties = new Properties();
            if (this.hzMulticastGroup != null) {
                properties.setProperty("payaramicro.mcAddress", this.hzMulticastGroup);
            }
            if (this.hzPort != Integer.MIN_VALUE) {
                properties.setProperty("payaramicro.mcPort", Integer.toString(this.hzPort));
            }
            if (this.hzStartPort != Integer.MIN_VALUE) {
                properties.setProperty("payaramicro.startPort", Integer.toString(this.hzStartPort));
            }
            properties.setProperty("payaramicro.name", this.instanceName);
            if (this.rootDir != null) {
                properties.setProperty("payaramicro.rootDir", this.rootDir.getAbsolutePath());
            }
            if (this.alternateDomainXML != null) {
                properties.setProperty("payaramicro.domainConfig", "META-INF/deploy/domain.xml");
            }
            if (this.minHttpThreads != Integer.MIN_VALUE) {
                properties.setProperty("payaramicro.minHttpThreads", Integer.toString(this.minHttpThreads));
            }
            if (this.maxHttpThreads != Integer.MIN_VALUE) {
                properties.setProperty("payaramicro.maxHttpThreads", Integer.toString(this.maxHttpThreads));
            }
            if (this.alternateHZConfigFile != null) {
                properties.setProperty("payaramicro.hzConfigFile", "META-INF/deploy/hzconfig.xml");
            }
            if (this.hzClusterName != null) {
                properties.setProperty("payaramicro.clusterName", this.hzClusterName);
            }
            if (this.hzClusterPassword != null) {
                properties.setProperty("payaramicro.clusterPassword", this.hzClusterPassword);
            }
            properties.setProperty("payaramicro.autoBindHttp", Boolean.toString(this.autoBindHttp));
            properties.setProperty("payaramicro.autoBindSsl", Boolean.toString(this.autoBindSsl));
            properties.setProperty("payaramicro.autoBindRange", Integer.toString(this.autoBindRange));
            properties.setProperty("payaramicro.lite", Boolean.toString(this.liteMember));
            properties.setProperty("payaramicro.enableHealthCheck", Boolean.toString(this.enableHealthCheck));
            properties.setProperty("payaramicro.logo", Boolean.toString(this.generateLogo));
            properties.setProperty("payaramicro.logToFile", Boolean.toString(this.logToFile));
            properties.setProperty("payaramicro.enableAccessLog", Boolean.toString(this.enableAccessLog));
            properties.setProperty("payaramicro.enableAccessLogFormat", Boolean.toString(this.enableAccessLogFormat));
            properties.setProperty("payaramicro.logPropertiesFile", Boolean.toString(this.logPropertiesFile));
            properties.setProperty("payaramicro.noCluster", Boolean.toString(this.noCluster));
            properties.setProperty("payaramicro.disablePhoneHome", Boolean.toString(this.disablePhoneHome));
            if (this.httpPort != Integer.MIN_VALUE) {
                properties.setProperty("payaramicro.port", Integer.toString(this.httpPort));
            }
            if (this.sslPort != Integer.MIN_VALUE) {
                properties.setProperty("payaramicro.sslPort", Integer.toString(this.sslPort));
            }
            if (this.userSystemProperties != null) {
                Enumeration<?> names = this.userSystemProperties.propertyNames();
                while (names.hasMoreElements()) {
                    name = (String)names.nextElement();
                    properties.setProperty(name, this.userSystemProperties.getProperty(name));
                }
            }
            properties.store(jos, "");
            jos.flush();
            jos.closeEntry();
            if (this.alternateDomainXML != null && this.alternateDomainXML.isFile() && this.alternateDomainXML.canRead()) {
                try {
                    throwable = null;
                    try (FileInputStream is = new FileInputStream(this.alternateDomainXML);){
                        JarEntry domainXml2 = new JarEntry("META-INF/deploy/domain.xml");
                        jos.putNextEntry(domainXml2);
                        buffer = new byte[4096];
                        int bytesRead4 = 0;
                        while ((bytesRead4 = ((InputStream)is).read(buffer)) != -1) {
                            jos.write(buffer, 0, bytesRead4);
                        }
                        jos.flush();
                        jos.closeEntry();
                    }
                    catch (Throwable domainXml2) {
                        throwable = domainXml2;
                        throw domainXml2;
                    }
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Error adding alternative domain.xml to the Uber Jar Skipping...", ioe);
                }
            }
            if (this.alternateHZConfigFile != null) {
                try {
                    throwable = null;
                    try (InputStream is = this.alternateHZConfigFile.toURL().openStream();){
                        JarEntry domainXml = new JarEntry("META-INF/deploy/hzconfig.xml");
                        jos.putNextEntry(domainXml);
                        buffer = new byte[4096];
                        int bytesRead5 = 0;
                        while ((bytesRead5 = is.read(buffer)) != -1) {
                            jos.write(buffer, 0, bytesRead5);
                        }
                        jos.flush();
                        jos.closeEntry();
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException ioe) {
                    logger.log(Level.WARNING, "Error adding alternative hzconfig.xml to the Uber Jar Skipping...", ioe);
                }
            }
            logger.info("Built Uber Jar " + this.uberJar + " in " + (System.currentTimeMillis() - start) + " (ms)");
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error creating Uber Jar " + this.uberJar.getAbsolutePath(), ex);
        }
    }

    private void configureSecurity() {
        String instanceRootStr = System.getProperty("com.sun.aas.instanceRoot");
        File configDir = new File(instanceRootStr, "config");
        if (System.getProperty("java.security.auth.login.config") == null) {
            System.setProperty("java.security.auth.login.config", new File(configDir.getAbsolutePath(), "login.conf").getAbsolutePath());
        }
        if (System.getProperty("java.security.policy") == null) {
            System.setProperty("java.security.policy", new File(configDir.getAbsolutePath(), "server.policy").getAbsolutePath());
        }
        if (System.getProperty("javax.net.ssl.keyStore") == null) {
            System.setProperty("javax.net.ssl.keyStore", new File(configDir.getAbsolutePath(), "keystore.jks").getAbsolutePath());
        }
        if (System.getProperty("javax.net.ssl.trustStore") == null) {
            System.setProperty("javax.net.ssl.trustStore", new File(configDir.getAbsolutePath(), "cacerts.jks").getAbsolutePath());
        }
    }
}

