/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.micro.services.data;

import fish.payara.micro.services.data.ApplicationDescriptor;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.glassfish.internal.data.ApplicationInfo;

public class InstanceDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String memberUUID;
    private String instanceName;
    private int httpPort;
    private int httpsPort;
    private InetAddress hostName = InetAddress.getLocalHost();
    private Map<String, ApplicationDescriptor> deployedApplications;

    public InstanceDescriptor(String UUID2) throws UnknownHostException {
        this.memberUUID = UUID2;
    }

    public void addApplication(ApplicationInfo info) {
        if (this.deployedApplications == null) {
            this.deployedApplications = new HashMap<String, ApplicationDescriptor>(3);
        }
        ApplicationDescriptor ad = new ApplicationDescriptor(info);
        this.deployedApplications.put(ad.getName(), ad);
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getMemberUUID() {
        return this.memberUUID;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(int httpPort) {
        this.httpPort = httpPort;
    }

    public String toString() {
        return "InstanceDescriptor{memberUUID=" + this.memberUUID + ", httpPort=" + this.httpPort + ", httpsPort=" + this.httpsPort + ", hostName=" + this.hostName + ", deployedApplications=" + this.deployedApplications + '}';
    }

    public InetAddress getHostName() {
        return this.hostName;
    }

    public void setHostName(InetAddress hostName) {
        this.hostName = hostName;
    }

    public Collection<ApplicationDescriptor> getDeployedApplications() {
        if (this.deployedApplications == null) {
            return new HashSet<ApplicationDescriptor>();
        }
        return this.deployedApplications.values();
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    public void removeApplication(ApplicationInfo applicationInfo) {
        if (this.deployedApplications == null) {
            this.deployedApplications = new HashMap<String, ApplicationDescriptor>(3);
        }
        this.deployedApplications.remove(applicationInfo.getName());
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (InstanceDescriptor.class.isInstance(obj)) {
            InstanceDescriptor descriptor = (InstanceDescriptor)obj;
            result = this.memberUUID.equals(descriptor.memberUUID);
        }
        return result;
    }

    public int hashCode() {
        return this.memberUUID.hashCode();
    }
}

