/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.exec;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import fish.payara.nucleus.hazelcast.HazelcastCore;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="payara-cluster-executor")
@RunLevel(value=10)
public class ClusterExecutionService {
    private static final Logger logger = Logger.getLogger(ClusterExecutionService.class.getCanonicalName());
    @Inject
    private HazelcastCore hzCore;

    @PostConstruct
    public void postConstruct() {
        if (this.hzCore.isEnabled()) {
            logger.info("Payara Clustered Exector Service Enabled");
        }
    }

    public <T extends Serializable> Future<T> runCallable(String memberUUID, Callable<T> callable) {
        Future<T> result = null;
        if (this.hzCore.isEnabled()) {
            HazelcastInstance instance = this.hzCore.getInstance();
            Set<Member> members = instance.getCluster().getMembers();
            Member toSubmitTo = null;
            for (Member member : members) {
                if (!member.getUuid().equals(memberUUID)) continue;
                toSubmitTo = member;
                break;
            }
            result = instance.getExecutorService("payara-cluster-execution").submitToMember(callable, toSubmitTo);
        }
        return result;
    }

    public <T extends Serializable> Map<String, Future<T>> runCallable(Collection<String> memberUUIDS, Callable<T> callable) {
        HashMap<String, Future<T>> result = new HashMap<String, Future<T>>(2);
        if (this.hzCore.isEnabled()) {
            HazelcastInstance instance = this.hzCore.getInstance();
            Set<Member> members = instance.getCluster().getMembers();
            HashSet<Member> membersToSubmit = new HashSet<Member>(members.size());
            for (Member member : members) {
                if (!memberUUIDS.contains(member.getUuid())) continue;
                membersToSubmit.add(member);
            }
            Map<Member, Future<T>> results = this.hzCore.getInstance().getExecutorService("payara-cluster-execution").submitToMembers(callable, membersToSubmit);
            for (Member member : results.keySet()) {
                result.put(member.getUuid(), results.get(member));
            }
        }
        return result;
    }

    public <T extends Serializable> Map<String, Future<T>> runCallable(Callable<T> callable) {
        HashMap<String, Future<T>> result = new HashMap<String, Future<T>>(2);
        if (this.hzCore.isEnabled()) {
            HazelcastInstance instance = this.hzCore.getInstance();
            Map<Member, Future<T>> results = this.hzCore.getInstance().getExecutorService("payara-cluster-execution").submitToAllMembers(callable);
            for (Member member : results.keySet()) {
                result.put(member.getUuid(), results.get(member));
            }
        }
        return result;
    }
}

