/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.HealthCheckWithThresholdExecutionOptions;
import fish.payara.nucleus.healthcheck.admin.HealthCheckServiceThresholdConfigurer;
import fish.payara.nucleus.healthcheck.preliminary.BaseThresholdHealthCheck;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="__edit-healthcheck-configure-service-threshold-on-das")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="__edit-healthcheck-configure-service-threshold-on-das")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
public class EditHealthCheckServiceThresholdConfigurerOnDas
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceThresholdConfigurer.class);
    @Inject
    ServiceLocator habitat;
    @Inject
    HealthCheckService healthCheckService;
    @Param(name="serviceName", optional=false)
    private String serviceName;
    @Param(name="thresholdCritical", optional=true)
    private String thresholdCritical;
    @Param(name="thresholdWarning", optional=true)
    private String thresholdWarning;
    @Param(name="thresholdGood", optional=true)
    private String thresholdGood;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;

    @Override
    public void execute(AdminCommandContext context) {
        BaseThresholdHealthCheck service;
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if ((service = this.habitat.getService(BaseThresholdHealthCheck.class, this.serviceName, new Annotation[0])) == null) {
            actionReport.appendMessage("No service found with name " + this.serviceName);
            return;
        }
        if (service.getOptions() == null) {
            actionReport.appendMessage("Setting the service thresholds for " + this.serviceName + " will require a server restart");
            return;
        }
        if (this.thresholdCritical != null) {
            ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdCritical(Integer.valueOf(this.thresholdCritical));
            actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.critical.success", "Critical threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdCritical));
            actionReport.appendMessage("\n");
        }
        if (this.thresholdWarning != null) {
            ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdWarning(Integer.valueOf(this.thresholdWarning));
            actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.warning.success", "Warning threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdWarning));
            actionReport.appendMessage("\n");
        }
        if (this.thresholdGood != null) {
            ((HealthCheckWithThresholdExecutionOptions)service.getOptions()).setThresholdGood(Integer.valueOf(this.thresholdGood));
            actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.threshold.good.success", "Good threshold for {0} service is set with value {1}.", this.serviceName, this.thresholdGood));
            actionReport.appendMessage("\n");
        }
        this.healthCheckService.shutdownHealthCheck();
        this.healthCheckService.bootstrapHealthCheck();
    }
}

