/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import fish.payara.nucleus.healthcheck.HealthCheckService;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="__enable-healthcheck-configurer-on-instance")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="__enable-healthcheck-configurer-on-instance")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
public class EnableHealthCheckConfigurerOnInstance
implements AdminCommand {
    @Inject
    HealthCheckService service;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        this.service.setEnabled(this.enabled);
        actionReport.appendMessage("Health Check Service staus set to " + this.enabled + " on " + this.target);
        this.service.shutdownHealthCheck();
        this.service.bootstrapHealthCheck();
    }
}

