/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.admin.HealthCheckServiceConfigurer;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="__enable-healthcheck-configure-service-on-das")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="__enable-healthcheck-configure-service-on-das")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
public class EnableHealthCheckServiceConfigurerOnDas
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceConfigurer.class);
    @Inject
    ServiceLocator habitat;
    @Inject
    HealthCheckService healthCheckService;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="time", optional=true)
    private String time;
    @Param(name="unit", optional=true)
    private String unit;
    @Param(name="serviceName", optional=false)
    private String serviceName;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        BaseHealthCheck service = this.habitat.getService(BaseHealthCheck.class, this.serviceName, new Annotation[0]);
        Object checkerByType = this.healthCheckService.getConfiguration().getCheckerByType(service.getCheckerType());
        if (service.getOptions() == null) {
            if (checkerByType == null) {
                actionReport.appendMessage("Enabling a new Healthcheck requires a server restart..");
                return;
            }
            service.setOptions(service.constructOptions(checkerByType));
        }
        if (this.enabled != null) {
            ((HealthCheckExecutionOptions)service.getOptions()).setEnabled(this.enabled);
        }
        if (this.time != null) {
            ((HealthCheckExecutionOptions)service.getOptions()).setTime(Long.valueOf(this.time));
        }
        if (this.unit != null) {
            ((HealthCheckExecutionOptions)service.getOptions()).setUnit(TimeUnit.valueOf(this.unit));
        }
        actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.status.success", "Service status for {0} is set to {1}.", this.serviceName, this.enabled));
        this.healthCheckService.registerCheck(checkerByType.getName(), service);
        this.healthCheckService.shutdownHealthCheck();
        this.healthCheckService.bootstrapHealthCheck();
    }
}

