/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="healthcheck-configure")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.configure")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="healthcheck-configure", description="Enables/Disables Health Check Service")})
public class HealthCheckConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckConfigurer.class);
    @Inject
    protected Logger logger;
    @Inject
    HealthCheckService service;
    @Inject
    ServiceLocator serviceLocator;
    @Inject
    protected Target targetUtil;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;

    @Override
    public void execute(AdminCommandContext context) {
        Config config;
        HealthCheckServiceConfiguration healthCheckServiceConfiguration;
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if ((healthCheckServiceConfiguration = (config = this.targetUtil.getConfig(this.target)).getExtensionByType(HealthCheckServiceConfiguration.class)) != null) {
            try {
                ConfigSupport.apply(new SingleConfigCode<HealthCheckServiceConfiguration>(){

                    @Override
                    public Object run(HealthCheckServiceConfiguration healthCheckServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        if (HealthCheckConfigurer.this.enabled != null) {
                            healthCheckServiceConfigurationProxy.enabled(HealthCheckConfigurer.this.enabled.toString());
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return healthCheckServiceConfigurationProxy;
                    }
                }, healthCheckServiceConfiguration);
            }
            catch (TransactionFailure ex) {
                this.logger.log(Level.WARNING, "Exception during command ", ex);
                actionReport.setMessage(ex.getCause().getMessage());
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.dynamic.booleanValue()) {
            this.enableOnTarget(actionReport, context, this.enabled);
        }
    }

    private void enableOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        CommandRunner.CommandInvocation inv = this.target.equals("server-config") ? runner.getCommandInvocation("__enable-healthcheck-configurer-on-das", subReport, context.getSubject()) : runner.getCommandInvocation("__enable-healthcheck-configurer-on-instance", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        params.add("enabled", enabled.toString());
        params.add("target", this.target);
        inv.parameters(params);
        inv.execute();
        if (subReport.hasWarnings()) {
            subReport.setMessage("");
        }
    }
}

