/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.healthcheck.HealthCheckService;
import fish.payara.nucleus.healthcheck.configuration.Checker;
import fish.payara.nucleus.healthcheck.configuration.HealthCheckServiceConfiguration;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="healthcheck-configure-service")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="healthcheck.configure.service")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="healthcheck-configure-service", description="Enables/Disables Health Check Service Specified With Name")})
public class HealthCheckServiceConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(HealthCheckServiceConfigurer.class);
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Target targetUtil;
    @Inject
    protected Logger logger;
    @Inject
    HealthCheckService healthCheckService;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="time", optional=true)
    private String time;
    @Param(name="unit", optional=true)
    private String unit;
    @Param(name="serviceName", optional=false)
    private String serviceName;
    @Param(name="name", optional=true)
    private String name;
    @Param(name="dynamic", optional=true, defaultValue="false")
    protected Boolean dynamic;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;

    @Override
    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        AdminCommandContext theContext = context;
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        Config config = this.targetUtil.getConfig(this.target);
        final BaseHealthCheck service = this.habitat.getService(BaseHealthCheck.class, this.serviceName, new Annotation[0]);
        if (service == null) {
            actionReport.appendMessage(strings.getLocalString("healthcheck.service.configure.status.error", "Service with name {0} could not be found.", this.serviceName));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        HealthCheckServiceConfiguration healthCheckServiceConfiguration = config.getExtensionByType(HealthCheckServiceConfiguration.class);
        Object checker = healthCheckServiceConfiguration.getCheckerByType(service.getCheckerType());
        try {
            final Checker[] createdChecker = new Checker[]{null};
            if (checker == null) {
                ConfigSupport.apply(new SingleConfigCode<HealthCheckServiceConfiguration>(){

                    @Override
                    public Object run(HealthCheckServiceConfiguration healthCheckServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        Checker checkerProxy = (Checker)healthCheckServiceConfigurationProxy.createChild(service.getCheckerType());
                        HealthCheckServiceConfigurer.this.applyValues(checkerProxy);
                        healthCheckServiceConfigurationProxy.getCheckerList().add(checkerProxy);
                        createdChecker[0] = checkerProxy;
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return healthCheckServiceConfigurationProxy;
                    }
                }, healthCheckServiceConfiguration);
            } else {
                createdChecker[0] = checker;
                ConfigSupport.apply(new SingleConfigCode<Checker>(){

                    @Override
                    public Object run(Checker checkerProxy) throws PropertyVetoException, TransactionFailure {
                        HealthCheckServiceConfigurer.this.applyValues(checkerProxy);
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return checkerProxy;
                    }
                }, checker);
            }
            if (this.dynamic.booleanValue()) {
                this.enableOnTarget(actionReport, theContext, service, createdChecker[0], this.enabled, this.time, this.unit);
            }
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }

    private void applyValues(Checker checkerProxy) throws PropertyVetoException {
        if (this.enabled != null) {
            checkerProxy.setEnabled(this.enabled.toString());
        }
        if (this.time != null) {
            checkerProxy.setTime(this.time);
        }
        if (this.unit != null) {
            checkerProxy.setUnit(this.unit);
        }
        if (this.name != null) {
            checkerProxy.setName(this.name);
        }
    }

    private void enableOnTarget(ActionReport actionReport, AdminCommandContext context, BaseHealthCheck service, Checker checker, Boolean enabled, String time, String unit) {
        CommandRunner runner = this.habitat.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        CommandRunner.CommandInvocation inv = this.target.equals("server-config") ? runner.getCommandInvocation("__enable-healthcheck-configure-service-on-das", subReport, context.getSubject()) : runner.getCommandInvocation("__enable-healthcheck-configure-service-on-instance", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        params.add("enabled", enabled.toString());
        params.add("target", this.target);
        params.add("time", time);
        params.add("unit", unit);
        params.add("serviceName", this.serviceName);
        inv.parameters(params);
        inv.execute();
        if (subReport.hasWarnings()) {
            subReport.setMessage("");
        }
    }
}

