/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.nucleus.healthcheck.HealthCheckExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.configuration.GarbageCollectorChecker;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import fish.payara.nucleus.notification.TimeHelper;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-gc")
@RunLevel(value=10)
public class GarbageCollectorHealthCheck
extends BaseHealthCheck<HealthCheckExecutionOptions, GarbageCollectorChecker> {
    private long youngLastCollectionCount;
    private long youngLastCollectionTime;
    private long oldLastCollectionCount;
    private long oldLastCollectionTime;

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, GarbageCollectorChecker.class);
    }

    @Override
    public HealthCheckExecutionOptions constructOptions(GarbageCollectorChecker checker) {
        return super.constructBaseOptions(checker);
    }

    @Override
    public HealthCheckResult doCheck() {
        HealthCheckResult result = new HealthCheckResult();
        List<GarbageCollectorMXBean> gcBeanList = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcBean : gcBeanList) {
            long diffTime;
            long diffCount;
            if ("PS Scavenge".equals(gcBean.getName()) || "G1 Young Generation".equals(gcBean.getName()) || "Copy".equals(gcBean.getName()) || "ParNew".equals(gcBean.getName())) {
                diffCount = gcBean.getCollectionCount() - this.youngLastCollectionCount;
                diffTime = gcBean.getCollectionTime() - this.youngLastCollectionTime;
                if (diffTime <= 0L) continue;
                result.add(new HealthCheckResultEntry(this.decideOnStatusWithDuration(diffTime), diffCount + " times Young GC (" + gcBean.getName() + ") after " + TimeHelper.prettyPrintDuration(diffTime)));
                this.youngLastCollectionCount = gcBean.getCollectionCount();
                this.youngLastCollectionTime = gcBean.getCollectionTime();
                continue;
            }
            if ("PS MarkSweep".equals(gcBean.getName()) || "G1 Old Generation".equals(gcBean.getName()) || "MarkSweepCompact".equals(gcBean.getName()) || "ConcurrentMarkSweep".equals(gcBean.getName())) {
                diffCount = gcBean.getCollectionCount() - this.oldLastCollectionCount;
                diffTime = gcBean.getCollectionTime() - this.oldLastCollectionTime;
                if (diffTime <= 0L) continue;
                result.add(new HealthCheckResultEntry(this.decideOnStatusWithDuration(diffTime), diffCount + " times Old GC (" + gcBean.getName() + ") after " + TimeHelper.prettyPrintDuration(diffTime)));
                this.oldLastCollectionCount = gcBean.getCollectionCount();
                this.oldLastCollectionTime = gcBean.getCollectionTime();
                continue;
            }
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "Could not identify GarbageCollectorMXBean with name: " + gcBean.getName()));
        }
        return result;
    }
}

