/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.healthcheck.preliminary;

import fish.payara.nucleus.healthcheck.HealthCheckHoggingThreadsExecutionOptions;
import fish.payara.nucleus.healthcheck.HealthCheckResult;
import fish.payara.nucleus.healthcheck.HealthCheckResultEntry;
import fish.payara.nucleus.healthcheck.HealthCheckResultStatus;
import fish.payara.nucleus.healthcheck.configuration.HoggingThreadsChecker;
import fish.payara.nucleus.healthcheck.entity.ThreadTimes;
import fish.payara.nucleus.healthcheck.preliminary.BaseHealthCheck;
import fish.payara.nucleus.notification.TimeHelper;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="healthcheck-threads")
@RunLevel(value=10)
public class HoggingThreadsHealthCheck
extends BaseHealthCheck<HealthCheckHoggingThreadsExecutionOptions, HoggingThreadsChecker> {
    private HashMap<Long, ThreadTimes> threadTimes = new HashMap();

    @PostConstruct
    void postConstruct() {
        this.postConstruct(this, HoggingThreadsChecker.class);
    }

    @Override
    public HealthCheckHoggingThreadsExecutionOptions constructOptions(HoggingThreadsChecker checker) {
        return new HealthCheckHoggingThreadsExecutionOptions(Boolean.valueOf(checker.getEnabled()), checker.getTime(), this.asTimeUnit(checker.getUnit()), checker.getThresholdPercentage(), checker.getRetryCount());
    }

    @Override
    public HealthCheckResult doCheck() {
        long[] ids;
        if (!((HealthCheckHoggingThreadsExecutionOptions)this.getOptions()).isEnabled()) {
            return null;
        }
        HealthCheckResult result = new HealthCheckResult();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        if (!threadBean.isCurrentThreadCpuTimeSupported()) {
            result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CHECK_ERROR, "JVM implementation or OS does not support getting CPU times"));
            return result;
        }
        for (long id : ids = threadBean.getAllThreadIds()) {
            if (id == Thread.currentThread().getId()) continue;
            long c = threadBean.getThreadCpuTime(id);
            long u = threadBean.getThreadUserTime(id);
            ThreadInfo threadInfo = threadBean.getThreadInfo(id);
            if (c == -1L || u == -1L) continue;
            ThreadTimes times = this.threadTimes.get(id);
            if (times == null) {
                times = new ThreadTimes();
                times.setId(id);
                times.setName(threadInfo.getThreadName());
                times.setStartCpuTime(c);
                times.setEndCpuTime(c);
                times.setStartUserTime(u);
                times.setEndUserTime(u);
                this.threadTimes.put(id, times);
                continue;
            }
            times.setStartCpuTime(times.getEndCpuTime());
            times.setStartUserTime(times.getEndUserTime());
            times.setEndCpuTime(c);
            times.setEndUserTime(u);
            long checkTime = ((HealthCheckHoggingThreadsExecutionOptions)this.getOptions()).getUnit().toMillis(((HealthCheckHoggingThreadsExecutionOptions)this.getOptions()).getTime());
            long duration = times.getEndCpuTime() - times.getStartCpuTime();
            double percentage = (double)TimeUnit.NANOSECONDS.toMillis(duration) / (double)checkTime * 100.0;
            if (!(percentage > (double)((HealthCheckHoggingThreadsExecutionOptions)this.options).getThresholdPercentage().longValue())) continue;
            if (times.getRetryCount() == 0) {
                times.setInitialStartCpuTime(System.nanoTime());
                times.setInitialStartUserTime(System.nanoTime());
            }
            if (times.getRetryCount() >= ((HealthCheckHoggingThreadsExecutionOptions)this.options).getRetryCount()) {
                result.add(new HealthCheckResultEntry(HealthCheckResultStatus.CRITICAL, "Thread with <id-name>: " + id + "-" + times.getName() + " is a hogging thread for the last " + TimeHelper.prettyPrintDuration(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - times.getInitialStartCpuTime())) + "\n" + this.prettyPrintStackTrace(threadInfo.getStackTrace())));
            }
            times.setRetryCount(times.getRetryCount() + 1);
        }
        return result;
    }
}

