/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification;

import fish.payara.nucleus.notification.NotificationEventBus;
import fish.payara.nucleus.notification.configuration.NotificationServiceConfiguration;
import fish.payara.nucleus.notification.configuration.NotifierConfiguration;
import fish.payara.nucleus.notification.domain.NotificationEvent;
import fish.payara.nucleus.notification.domain.execoptions.NotificationExecutionOptions;
import fish.payara.nucleus.notification.domain.execoptions.NotifierConfigurationExecutionOptionsFactory;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service(name="notification-service")
@RunLevel(value=10)
public class NotificationService
implements EventListener {
    private static final Logger logger = Logger.getLogger(NotificationService.class.getCanonicalName());
    @Inject
    @Named(value="default-instance-name")
    @Optional
    NotificationServiceConfiguration configuration;
    @Inject
    private Events events;
    @Inject
    ServiceLocator habitat;
    @Inject
    private NotificationEventBus notificationEventBus;
    @Inject
    private NotifierConfigurationExecutionOptionsFactory executionOptionsFactory;
    private NotificationExecutionOptions executionOptions = new NotificationExecutionOptions();

    @PostConstruct
    void postConstruct() {
        if (this.configuration != null) {
            this.executionOptions.setEnabled(this.configuration.getEnabled());
            for (NotifierConfiguration notifierConfiguration : this.configuration.getNotifierConfigurationList()) {
                this.executionOptions.addNotifierConfigurationExecutionOption(this.executionOptionsFactory.build(notifierConfiguration));
            }
        }
        this.events.register(this);
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_READY)) {
            this.bootstrapNotificationService();
        }
    }

    private void bootstrapNotificationService() {
        if (this.executionOptions.isEnabled()) {
            logger.info("Payara Notification Service Started with configuration: " + this.executionOptions);
        }
    }

    public void notify(NotificationEvent notificationEvent) {
        this.notificationEventBus.postEvent(notificationEvent);
    }

    public NotificationExecutionOptions getExecutionOptions() {
        return this.executionOptions;
    }
}

