/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.notification.NotificationService;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="__enable-notification-configure-instance")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="__enable-notification-configure-instance")
@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
public class EnableNotificationConfigurerOnInstance
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(EnableNotificationConfigurerOnInstance.class);
    @Inject
    NotificationService service;
    @Inject
    protected Logger logger;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (this.enabled != null) {
            this.service.getExecutionOptions().setEnabled(this.enabled);
            actionReport.appendMessage(strings.getLocalString("notification.configure.status.success", "Notification service status is set to {0}.", this.enabled) + "\n");
        }
    }
}

