/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.notification.NotificationEventBus;
import fish.payara.nucleus.notification.NotificationService;
import fish.payara.nucleus.notification.configuration.NotificationServiceConfiguration;
import fish.payara.nucleus.notification.configuration.NotifierConfiguration;
import fish.payara.nucleus.notification.domain.execoptions.NotifierConfigurationExecutionOptions;
import fish.payara.nucleus.notification.domain.execoptions.NotifierConfigurationExecutionOptionsFactory;
import fish.payara.nucleus.notification.service.BaseNotifierService;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="__enable-notification-configure-notifier-instance")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="__enable-notification-configure-notifier-instance")
public class EnableNotificationNotifierConfigurerOnInstance
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(EnableNotificationNotifierConfigurerOnInstance.class);
    @Inject
    NotificationService service;
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Logger logger;
    @Inject
    protected Target targetUtil;
    @Inject
    private NotifierConfigurationExecutionOptionsFactory factory;
    @Inject
    private NotificationEventBus eventBus;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="notifierName", optional=true, defaultValue="service-log")
    private String notifierName;
    @Param(name="notifierEnabled", optional=false)
    private Boolean notifierEnabled;

    @Override
    public void execute(AdminCommandContext context) {
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        Config config = this.targetUtil.getConfig(this.target);
        final BaseNotifierService notifierService = this.habitat.getService(BaseNotifierService.class, this.notifierName, new Annotation[0]);
        if (notifierService == null) {
            actionReport.appendMessage(strings.getLocalString("requesttracing.notifier.configure.status.error", "Notifier with name {0} could not be found.", this.notifierName));
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        NotificationServiceConfiguration notificationServiceConfiguration = config.getExtensionByType(NotificationServiceConfiguration.class);
        Object notifier = notificationServiceConfiguration.getNotifierConfigurationByType(notifierService.getNotifierConfigType());
        try {
            if (notifier == null) {
                final NotifierConfiguration[] createdNotifier = new NotifierConfiguration[]{null};
                ConfigSupport.apply(new SingleConfigCode<NotificationServiceConfiguration>(){

                    @Override
                    public Object run(NotificationServiceConfiguration notificationServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        NotifierConfiguration notifierProxy;
                        createdNotifier[0] = notifierProxy = (NotifierConfiguration)notificationServiceConfigurationProxy.createChild(notifierService.getNotifierConfigType());
                        List<NotifierConfiguration> notifierConfigList = notificationServiceConfigurationProxy.getNotifierConfigurationList();
                        NotifierConfigurationExecutionOptions executionOptions = EnableNotificationNotifierConfigurerOnInstance.this.factory.build(createdNotifier[0]);
                        if (EnableNotificationNotifierConfigurerOnInstance.this.notifierEnabled.booleanValue()) {
                            notifierConfigList.add(createdNotifier[0]);
                            EnableNotificationNotifierConfigurerOnInstance.this.service.getExecutionOptions().addNotifierConfigurationExecutionOption(executionOptions);
                            EnableNotificationNotifierConfigurerOnInstance.this.eventBus.register(notifierService);
                        } else {
                            notifierConfigList.remove(createdNotifier[0]);
                            EnableNotificationNotifierConfigurerOnInstance.this.service.getExecutionOptions().removeNotifierConfigurationExecutionOption(executionOptions);
                            EnableNotificationNotifierConfigurerOnInstance.this.eventBus.unregister(notifierService);
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return notificationServiceConfigurationProxy;
                    }
                }, notificationServiceConfiguration);
            } else {
                ConfigSupport.apply(new SingleConfigCode<NotifierConfiguration>(){

                    @Override
                    public Object run(NotifierConfiguration notifierProxy) throws PropertyVetoException, TransactionFailure {
                        NotifierConfigurationExecutionOptions executionOptions = EnableNotificationNotifierConfigurerOnInstance.this.factory.build(notifierProxy);
                        if (EnableNotificationNotifierConfigurerOnInstance.this.notifierEnabled.booleanValue()) {
                            EnableNotificationNotifierConfigurerOnInstance.this.service.getExecutionOptions().addNotifierConfigurationExecutionOption(executionOptions);
                            EnableNotificationNotifierConfigurerOnInstance.this.eventBus.register(notifierService);
                        } else {
                            EnableNotificationNotifierConfigurerOnInstance.this.service.getExecutionOptions().removeNotifierConfigurationExecutionOption(executionOptions);
                            EnableNotificationNotifierConfigurerOnInstance.this.eventBus.unregister(notifierService);
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return notifierProxy;
                    }
                }, notifier);
            }
            actionReport.appendMessage(strings.getLocalString("notification.configure.notifier.added.configured", "Notifier with name {0} is registered and set enabled to {1}.", this.notifierName, this.notifierEnabled) + "\n");
        }
        catch (TransactionFailure ex) {
            this.logger.log(Level.WARNING, "Exception during command ", ex);
            actionReport.setMessage(ex.getCause().getMessage());
            actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
    }
}

