/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.ColumnFormatter;
import fish.payara.nucleus.notification.configuration.LogNotifierConfiguration;
import fish.payara.nucleus.notification.configuration.NotificationServiceConfiguration;
import fish.payara.nucleus.notification.service.BaseNotifierService;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="get-notification-configuration")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="get.notification.configuration")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="get-notification-configuration", description="List Notification Configuration")})
public class GetNotificationConfiguration
implements AdminCommand {
    @Inject
    private Target targetUtil;
    @Inject
    ServiceLocator habitat;
    @Param(name="target", optional=true, defaultValue="server")
    String target;

    @Override
    public void execute(AdminCommandContext context) {
        Config config = this.targetUtil.getConfig(this.target);
        if (config == null) {
            context.getActionReport().setMessage("No such config named: " + this.target);
            context.getActionReport().setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        ActionReport mainActionReport = context.getActionReport();
        NotificationServiceConfiguration notificationServiceConfiguration = config.getExtensionByType(NotificationServiceConfiguration.class);
        NotificationServiceConfiguration configuration = config.getExtensionByType(NotificationServiceConfiguration.class);
        List<ServiceHandle<BaseNotifierService>> allServiceHandles = this.habitat.getAllServiceHandles(BaseNotifierService.class, new Annotation[0]);
        String[] headers = new String[]{"Enabled", "Notifier Enabled", "Notifier Name"};
        ColumnFormatter columnFormatter = new ColumnFormatter(headers);
        Object[] values = new Object[3];
        values[0] = notificationServiceConfiguration.getEnabled();
        for (ServiceHandle<BaseNotifierService> serviceHandle : allServiceHandles) {
            Object notifierConfiguration = configuration.getNotifierConfigurationByType(serviceHandle.getService().getNotifierConfigType());
            LogNotifierConfiguration logNotifierConfiguration = (LogNotifierConfiguration)notifierConfiguration;
            values[1] = logNotifierConfiguration.getEnabled();
            values[2] = serviceHandle.getActiveDescriptor().getName();
        }
        columnFormatter.addRow(values);
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        Properties extraProps = new Properties();
        map.put("enabled", values[0]);
        map.put("notifierEnabled", values[1]);
        map.put("notifierName", values[2]);
        extraProps.put("getNotificationConfiguration", map);
        mainActionReport.setExtraProperties(extraProps);
        mainActionReport.setMessage(columnFormatter.toString());
        mainActionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

