/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.notification.service;

import fish.payara.nucleus.notification.NotificationEventBus;
import fish.payara.nucleus.notification.NotificationService;
import fish.payara.nucleus.notification.configuration.LogNotifier;
import fish.payara.nucleus.notification.configuration.NotifierConfiguration;
import fish.payara.nucleus.notification.configuration.NotifierType;
import fish.payara.nucleus.notification.domain.NotificationEvent;
import javax.inject.Inject;
import org.jvnet.hk2.annotations.Contract;

@Contract
public abstract class BaseNotifierService<E extends NotificationEvent, C extends LogNotifier, NC extends NotifierConfiguration> {
    @Inject
    private NotificationEventBus eventBus;
    @Inject
    private NotificationService notificationService;
    private NotifierType type;
    private Class<C> notifierType;
    private Class<NC> notifierConfigType;

    void register(NotifierType type2, Class<C> notifierType, Class<NC> notifierConfigType, BaseNotifierService service) {
        this.type = type2;
        this.notifierType = notifierType;
        this.notifierConfigType = notifierConfigType;
        if (this.notificationService.getExecutionOptions().isNotifierServiceEnabled(type2)) {
            this.eventBus.register(service);
        }
    }

    public abstract void handleNotification(E var1);

    public Class<C> getNotifierType() {
        return this.notifierType;
    }

    public Class<NC> getNotifierConfigType() {
        return this.notifierConfigType;
    }

    public NotifierType getType() {
        return this.type;
    }
}

