/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.phonehome;

import com.sun.enterprise.config.serverbeans.Domain;
import fish.payara.nucleus.phonehome.PhoneHomeRuntimeConfiguration;
import fish.payara.nucleus.phonehome.PhoneHomeTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.hk2.runlevel.RunLevel;
import org.jvnet.hk2.annotations.Service;

@Service(name="phonehome-core")
@RunLevel(value=10)
public class PhoneHomeCore
implements EventListener {
    private static final String THREAD_NAME = "PhoneHomeThread";
    private static PhoneHomeCore theCore;
    private static Boolean overrideEnabled;
    private boolean enabled;
    private ScheduledExecutorService executor;
    @Inject
    @Named(value="default-instance-name")
    PhoneHomeRuntimeConfiguration configuration;
    @Inject
    private ServerEnvironment env;
    @Inject
    private Events events;
    @Inject
    private Domain domain;

    @PostConstruct
    public void postConstruct() {
        theCore = this;
        this.events.register(this);
        if (this.env.isDas()) {
            this.enabled = this.configuration == null ? true : Boolean.valueOf(this.configuration.getEnabled());
            if (overrideEnabled != null) {
                this.enabled = overrideEnabled;
            }
        } else {
            this.enabled = false;
        }
    }

    @Override
    public void event(EventListener.Event event) {
        if (event.is(EventTypes.SERVER_STARTUP)) {
            this.bootstrapPhoneHome();
        } else if (event.is(EventTypes.SERVER_SHUTDOWN)) {
            this.shutdownPhoneHome();
        }
    }

    private void bootstrapPhoneHome() {
        if (this.enabled) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    return new Thread(r, PhoneHomeCore.THREAD_NAME);
                }
            });
            this.executor.scheduleAtFixedRate(new PhoneHomeTask(this.domain, this.env), 0L, 1L, TimeUnit.DAYS);
        }
    }

    private void shutdownPhoneHome() {
        if (this.executor != null) {
            this.executor.shutdownNow();
        }
    }

    public void enable() {
        this.setEnabled(true);
    }

    public void disable() {
        this.setEnabled(false);
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void start() {
        if (this.enabled) {
            this.shutdownPhoneHome();
            this.bootstrapPhoneHome();
        } else {
            this.enabled = true;
            this.bootstrapPhoneHome();
        }
    }

    public void stop() {
        if (this.enabled) {
            this.enabled = false;
            this.shutdownPhoneHome();
        }
    }

    public static void setOverrideEnabled(boolean enabled) {
        overrideEnabled = enabled;
    }
}

