/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing;

import fish.payara.nucleus.requesttracing.RequestTrace;
import fish.payara.nucleus.requesttracing.domain.RequestEvent;
import javax.inject.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class RequestEventStore {
    private ThreadLocal<RequestTrace> eventStore = new ThreadLocal<RequestTrace>(){

        @Override
        protected RequestTrace initialValue() {
            return new RequestTrace();
        }
    };

    void storeEvent(RequestEvent requestEvent) {
        RequestTrace currentTrace = this.eventStore.get();
        currentTrace.addEvent(requestEvent);
    }

    long getElapsedTime() {
        return this.eventStore.get().getElapsedTime();
    }

    void flushStore() {
        this.eventStore.set(new RequestTrace());
    }

    String getTraceAsString() {
        return this.eventStore.get().toString();
    }

    RequestTrace getTrace() {
        return this.eventStore.get();
    }
}

