/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing;

import fish.payara.nucleus.requesttracing.domain.EventType;
import fish.payara.nucleus.requesttracing.domain.RequestEvent;
import java.util.LinkedList;

public class RequestTrace {
    private boolean started;
    private boolean completed;
    private long startTime;
    private long elapsedTime;
    private LinkedList<RequestEvent> trace = new LinkedList();

    void addEvent(RequestEvent requestEvent) {
        if (this.completed && requestEvent.getEventType() != EventType.TRACE_START) {
            return;
        }
        if (null != requestEvent.getEventType()) {
            switch (requestEvent.getEventType()) {
                case TRACE_START: {
                    this.trace.clear();
                    this.startTime = requestEvent.getTimestamp();
                    requestEvent.setConversationId(requestEvent.getId());
                    this.trace.add(requestEvent);
                    this.started = true;
                    break;
                }
                case REQUEST_EVENT: {
                    if (!this.started) {
                        return;
                    }
                    RequestEvent startEvent = this.trace.getFirst();
                    requestEvent.setConversationId(startEvent.getConversationId());
                    requestEvent.setTraceTime(requestEvent.getTimestamp() - this.startTime);
                    this.trace.add(requestEvent);
                    break;
                }
                case TRACE_END: {
                    if (!this.started) {
                        return;
                    }
                    RequestEvent startEvent = this.trace.getFirst();
                    requestEvent.setConversationId(startEvent.getConversationId());
                    requestEvent.setTraceTime(requestEvent.getTimestamp() - this.startTime);
                    this.trace.add(requestEvent);
                    this.elapsedTime = requestEvent.getTimestamp() - this.startTime;
                    this.completed = true;
                    break;
                }
            }
        }
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{\"RequestTrace\": {");
        sb.append("\"startTime\":\"").append(this.startTime).append('\"').append(",\"elapsedTime\":\"").append(this.elapsedTime).append('\"').append(',');
        for (RequestEvent re : this.trace) {
            sb.append(re.toString());
            if (re.getEventType() == EventType.TRACE_END) continue;
            sb.append(',');
        }
        sb.append("}}");
        return sb.toString();
    }

    boolean isStarted() {
        return this.started;
    }

    LinkedList<RequestEvent> getTrace() {
        return this.trace;
    }

    long getStartTime() {
        return this.startTime;
    }
}

