/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.notification.configuration.NotifierType;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.domain.execoptions.NotifierExecutionOptions;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="__enable-requesttracing-configure-das")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="__enable-requesttracing-configure-das")
public class EnableRequestTracingConfigurerOnDas
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(EnableRequestTracingConfigurerOnDas.class);
    @Inject
    RequestTracingService service;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="thresholdUnit", optional=true, defaultValue="SECONDS")
    private String unit;
    @Param(name="thresholdValue", optional=true, defaultValue="30")
    private String value;

    @Override
    public void execute(AdminCommandContext context) {
        AdminCommandContext theContext = context;
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (this.enabled != null) {
            this.service.getExecutionOptions().setEnabled(this.enabled);
            Map<NotifierType, NotifierExecutionOptions> notifierExecutionOptionsList = this.service.getExecutionOptions().getNotifierExecutionOptionsList();
            if (notifierExecutionOptionsList != null) {
                for (Map.Entry<NotifierType, NotifierExecutionOptions> entry : notifierExecutionOptionsList.entrySet()) {
                    NotifierExecutionOptions value1 = entry.getValue();
                    value1.setEnabled(this.enabled);
                }
            }
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.status.success", "request tracing service status is set to {0}.", this.enabled) + "\n");
        }
        if (this.value != null) {
            this.service.getExecutionOptions().setThresholdValue(Long.valueOf(this.value));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.thresholdvalue.success", "Request Tracing Service Threshold Value is set to {0}.", this.value) + "\n");
        }
        if (this.unit != null) {
            this.service.getExecutionOptions().setThresholdUnit(TimeUnit.valueOf(this.unit));
            actionReport.appendMessage(strings.getLocalString("requesttracing.configure.thresholdunit.success", "Request Tracing Service Threshold Unit is set to {0}.", this.unit) + "\n");
        }
    }
}

