/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.notification.configuration.NotifierType;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.admin.RequestTracingNotifierConfigurer;
import fish.payara.nucleus.requesttracing.domain.execoptions.NotifierExecutionOptions;
import fish.payara.nucleus.requesttracing.domain.execoptions.NotifierExecutionOptionsFactory;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="__enable-requesttracing-configure-notifier-instance")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="__enable-requesttracing-configure-notifier-instance")
public class EnableRequestTracingNotifierConfigurerOnInstance
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(RequestTracingNotifierConfigurer.class);
    @Inject
    RequestTracingService service;
    @Inject
    NotifierExecutionOptionsFactory factory;
    @Inject
    ServiceLocator habitat;
    @Inject
    protected Logger logger;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="notifierName", optional=true, defaultValue="service-log")
    private String notifierName;
    @Param(name="notifierEnabled", optional=false)
    private Boolean notifierEnabled;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        Map<NotifierType, NotifierExecutionOptions> notifierExecutionOptionsList = this.service.getExecutionOptions().getNotifierExecutionOptionsList();
        for (Map.Entry<NotifierType, NotifierExecutionOptions> entry : notifierExecutionOptionsList.entrySet()) {
            NotifierExecutionOptions value = entry.getValue();
            value.setEnabled(this.notifierEnabled);
        }
    }
}

