/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import fish.payara.nucleus.requesttracing.RequestTracingService;
import fish.payara.nucleus.requesttracing.configuration.RequestTracingServiceConfiguration;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="requesttracing-configure")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="requesttracing.configure")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="requesttracing-configure", description="Enables/Disables Request Tracing Service")})
public class RequestTracingConfigurer
implements AdminCommand {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(RequestTracingConfigurer.class);
    @Inject
    RequestTracingService service;
    @Inject
    protected Logger logger;
    @Inject
    protected Target targetUtil;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="thresholdUnit", optional=true, defaultValue="SECONDS")
    private String unit;
    @Param(name="thresholdValue", optional=true, defaultValue="30")
    private String value;
    @Inject
    ServiceLocator serviceLocator;
    CommandRunner.CommandInvocation inv;

    @Override
    public void execute(AdminCommandContext context) {
        AdminCommandContext theContext = context;
        final ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (!this.validate(actionReport)) {
            return;
        }
        Config config = this.targetUtil.getConfig(this.target);
        RequestTracingServiceConfiguration requestTracingServiceConfiguration = config.getExtensionByType(RequestTracingServiceConfiguration.class);
        if (requestTracingServiceConfiguration != null) {
            try {
                ConfigSupport.apply(new SingleConfigCode<RequestTracingServiceConfiguration>(){

                    @Override
                    public Object run(RequestTracingServiceConfiguration requestTracingServiceConfigurationProxy) throws PropertyVetoException, TransactionFailure {
                        if (RequestTracingConfigurer.this.enabled != null) {
                            requestTracingServiceConfigurationProxy.enabled(RequestTracingConfigurer.this.enabled.toString());
                        }
                        if (RequestTracingConfigurer.this.unit != null) {
                            requestTracingServiceConfigurationProxy.setThresholdUnit(RequestTracingConfigurer.this.unit);
                        }
                        if (RequestTracingConfigurer.this.value != null) {
                            requestTracingServiceConfigurationProxy.setThresholdValue(RequestTracingConfigurer.this.value);
                        }
                        actionReport.setActionExitCode(ActionReport.ExitCode.SUCCESS);
                        return requestTracingServiceConfigurationProxy;
                    }
                }, requestTracingServiceConfiguration);
            }
            catch (TransactionFailure ex) {
                this.logger.log(Level.WARNING, "Exception during command ", ex);
                actionReport.setMessage(ex.getCause().getMessage());
                actionReport.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
        }
        if (this.dynamic.booleanValue()) {
            this.enableOnTarget(actionReport, theContext, this.enabled);
        }
    }

    private void enableOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        this.inv = this.target.equals("server-config") ? runner.getCommandInvocation("__enable-requesttracing-configure-das", subReport, context.getSubject()) : runner.getCommandInvocation("__enable-requesttracing-configure-instance", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        params.add("enabled", enabled.toString());
        params.add("target", this.target);
        params.add("thresholdUnit", this.unit);
        params.add("thresholdValue", this.value);
        this.inv.parameters(params);
        this.inv.execute();
        if (subReport.hasWarnings()) {
            subReport.setMessage("");
        }
    }

    private boolean validate(ActionReport actionReport) {
        boolean result = false;
        if (this.value != null) {
            try {
                int thresholdValue = Integer.parseInt(this.value);
                if (thresholdValue <= 0 || thresholdValue > 65534) {
                    actionReport.failure(this.logger, "Threshold Value must be greater than zero or less than 655341");
                    return result;
                }
            }
            catch (NumberFormatException nfe) {
                actionReport.failure(this.logger, "Threshold Value is not a valid integer", nfe);
                return result;
            }
        }
        if (this.unit != null) {
            try {
                if (!(this.unit.equals("NANOSECONDS") || this.unit.equals("MICROSECONDS") || this.unit.equals("MILLISECONDS") || this.unit.equals("SECONDS") || this.unit.equals("MINUTES") || this.unit.equals("HOURS") || this.unit.equals("DAYS"))) {
                    actionReport.failure(this.logger, this.unit + " is an invalid time unit");
                    return result;
                }
            }
            catch (IllegalArgumentException iaf) {
                actionReport.failure(this.logger, this.unit + " is an invalid time unit", iaf);
                return result;
            }
        }
        return true;
    }
}

