/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@Service(name="set-requesttracing-configuration")
@CommandLock(value=CommandLock.LockType.NONE)
@PerLookup
@I18n(value="set.requesttracing.configuration")
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="set-requesttracing-configuration", description="Set Request Tracing Services Configuration")})
public class SetRequestTracingConfiguration
implements AdminCommand {
    @Inject
    protected Logger logger;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="enabled", optional=false)
    private Boolean enabled;
    @Param(name="dynamic", optional=true, defaultValue="false")
    private Boolean dynamic;
    @Param(name="thresholdUnit", optional=true, defaultValue="SECONDS")
    private String unit;
    @Param(name="thresholdValue", optional=true, defaultValue="30")
    private String value;
    @Param(name="notifierDynamic", optional=true, defaultValue="false")
    private Boolean notifierDynamic;
    @Param(name="notifierEnabled", optional=false)
    private Boolean notifierEnabled;
    @Param(name="notifierName", optional=true, defaultValue="service-log")
    private String notifierName;
    @Inject
    ServiceLocator serviceLocator;
    CommandRunner.CommandInvocation inv;

    @Override
    public void execute(AdminCommandContext context) {
        AdminCommandContext theContext = context;
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        if (!this.validate(actionReport)) {
            return;
        }
        if (this.dynamic.booleanValue() || this.enabled.booleanValue()) {
            this.notifierDynamic = this.dynamic != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.notifierEnabled = this.enabled != false ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.enableRequestTracingConfigureOnTarget(actionReport, theContext, this.enabled);
        }
        if (this.notifierDynamic.booleanValue() || this.notifierEnabled.booleanValue()) {
            this.enableRequestTracingNotifierConfigurerOnTarget(actionReport, theContext, this.notifierEnabled);
        }
    }

    private void enableRequestTracingConfigureOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        this.inv = runner.getCommandInvocation("requesttracing-configure", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        params.add("enabled", enabled.toString());
        params.add("target", this.target);
        params.add("dynamic", this.dynamic.toString());
        params.add("thresholdUnit", this.unit);
        params.add("thresholdValue", this.value);
        this.inv.parameters(params);
        this.inv.execute();
        if (subReport.hasWarnings()) {
            subReport.setMessage("");
        }
    }

    private void enableRequestTracingNotifierConfigurerOnTarget(ActionReport actionReport, AdminCommandContext context, Boolean enabled) {
        CommandRunner runner = this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        this.inv = runner.getCommandInvocation("requesttracing-configure-notifier", subReport, context.getSubject());
        ParameterMap params = new ParameterMap();
        params.add("dynamic", this.notifierDynamic.toString());
        params.add("target", this.target);
        params.add("notifierName", this.notifierName);
        params.add("notifierEnabled", enabled.toString());
        this.inv.parameters(params);
        this.inv.execute();
        if (subReport.hasWarnings()) {
            subReport.setMessage("");
        }
    }

    private boolean validate(ActionReport actionReport) {
        boolean result = false;
        if (this.value != null) {
            try {
                int thresholdValue = Integer.parseInt(this.value);
                if (thresholdValue <= 0 || thresholdValue > 65534) {
                    actionReport.failure(this.logger, "Threshold Value must be greater than zero or less than 655341");
                    return result;
                }
            }
            catch (NumberFormatException nfe) {
                actionReport.failure(this.logger, "Threshold Value is not a valid integer", nfe);
                return result;
            }
        }
        if (this.unit != null) {
            try {
                if (!(this.unit.equals("NANOSECONDS") || this.unit.equals("MICROSECONDS") || this.unit.equals("MILLISECONDS") || this.unit.equals("SECONDS") || this.unit.equals("MINUTES") || this.unit.equals("HOURS") || this.unit.equals("DAYS"))) {
                    actionReport.failure(this.logger, this.unit + " is an invalid time unit");
                    return result;
                }
            }
            catch (IllegalArgumentException iaf) {
                actionReport.failure(this.logger, this.unit + " is an invalid time unit", iaf);
                return result;
            }
        }
        return true;
    }
}

