/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.nucleus.requesttracing.domain;

import fish.payara.nucleus.requesttracing.domain.EventType;
import java.util.HashMap;
import java.util.UUID;

public class RequestEvent
implements Comparable<RequestEvent> {
    private final UUID id = UUID.randomUUID();
    private UUID conversationId;
    private final long timestamp = System.currentTimeMillis();
    private long traceTime;
    private final EventType eventType;
    private HashMap<String, String> properties;
    private String eventName;

    public RequestEvent(String eventName) {
        this(EventType.REQUEST_EVENT, eventName);
    }

    public RequestEvent(EventType eventType, String eventName) {
        this.eventType = eventType;
        this.eventName = eventName;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getConversationId() {
        return this.conversationId;
    }

    public void setConversationId(UUID conversationId) {
        this.conversationId = conversationId;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getTraceTime() {
        return this.traceTime;
    }

    public void setTraceTime(long traceTime) {
        this.traceTime = traceTime;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public void addProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(name, value);
    }

    public String toString() {
        StringBuilder result = new StringBuilder("\n\"TraceEvent\": {");
        result.append("\"eventType\": \"").append((Object)this.eventType).append("\",").append("\"eventName\":\"").append(this.eventName).append("\",").append("\"id=\":\"").append(this.id).append("\",").append("\"conversationId=\":\"").append(this.conversationId).append("\",").append("\"timestamp=\":\"").append(this.timestamp).append("\",");
        if (this.properties != null) {
            for (String key : this.properties.keySet()) {
                result.append("\"").append(key).append("\": \"").append(this.properties.get(key)).append("\",");
            }
        }
        result.append("\"traceTime=\":\"").append(this.traceTime).append('\"');
        result.append('}');
        return result.toString();
    }

    @Override
    public int compareTo(RequestEvent o) {
        return this.timestamp > o.timestamp ? 1 : -1;
    }
}

