/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import com.sun.enterprise.config.serverbeans.Domain;
import java.beans.PropertyChangeEvent;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.config.AMXConfigImpl;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupport;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupportRegistry;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.impl.util.SingletonEnforcer;
import org.glassfish.admin.amx.util.AMXLoggerInfo;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.mbeanserver.PendingConfigBeanJob;
import org.glassfish.admin.mbeanserver.PendingConfigBeans;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
public final class AMXConfigLoader
implements TransactionListener {
    private volatile AMXConfigLoaderThread mLoaderThread;
    private final Transactions mTransactions;
    private final Logger mLogger = AMXLoggerInfo.getLogger();
    private final PendingConfigBeans mPendingConfigBeans;
    private final ConfigBeanRegistry mRegistry = ConfigBeanRegistry.getInstance();
    private final MBeanServer mServer;
    private static final Pattern ILLEGAL_JMX_NAME_PATTERN = Pattern.compile(".*[=:" + Pattern.quote("\"") + Pattern.quote("*") + Pattern.quote("?") + "].*");
    private static final AtomicLong sCounter = new AtomicLong(1L);

    private static void debug(String s) {
        System.out.println(s);
    }

    public AMXConfigLoader(MBeanServer mbeanServer, PendingConfigBeans pending, Transactions transactions) {
        if (transactions == null) {
            throw new IllegalStateException("AMXConfigLoader.AMXConfigLoader: null Transactions");
        }
        this.mServer = mbeanServer;
        this.mTransactions = transactions;
        this.mPendingConfigBeans = pending;
    }

    public void registerConfigured(Class<? extends ConfigBeanProxy> intf) {
        ConfigBeanJMXSupportRegistry.getInstance(intf);
    }

    public Map<String, String> getConfiguredTypes() {
        List<Class<? extends ConfigBeanProxy>> classes = ConfigBeanJMXSupportRegistry.getConfiguredClasses();
        Map<String, String> types = MapUtil.newMap();
        for (Class<? extends ConfigBeanProxy> clazz : classes) {
            String classname = clazz.getName();
            String elementType = Util.typeFromName(classname);
            types.put(elementType, classname);
        }
        return types;
    }

    private void configBeanRemoved(ConfigBean cb) {
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName != null) {
            ImplUtil.unregisterAMXMBeans(this.mServer, objectName);
            this.mRegistry.remove(objectName);
        } else {
            this.mPendingConfigBeans.remove(cb);
        }
    }

    private void issueAttributeChange(ConfigBean cb, String xmlAttrName, Object oldValue, Object newValue, long whenChanged) {
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName == null) {
            throw new IllegalArgumentException("Can't issue attribute change for null ObjectName for ConfigBean " + cb.getProxyType().getName());
        }
        boolean changed = false;
        if (oldValue != null) {
            changed = !oldValue.equals(newValue);
        } else if (newValue != null) {
            changed = true;
        }
        if (changed) {
            Object impl = this.mRegistry.getImpl(cb);
            if (!(impl instanceof AMXConfigImpl)) {
                throw new IllegalStateException("impossible");
            }
            AMXConfigImpl amx = (AMXConfigImpl)impl;
            String message = cb.getProxyType().getName() + "." + xmlAttrName + ": " + oldValue + " => " + newValue;
            amx.issueAttributeChangeForXmlAttrName(xmlAttrName, message, oldValue, newValue, whenChanged);
        }
    }

    private void sortAndDispatch(List<PropertyChangeEvent> events, long whenChanged) {
        Object newValue;
        Object oldValue;
        ArrayList<ConfigBean> newConfigBeans = new ArrayList<ConfigBean>();
        ArrayList<PropertyChangeEvent> remainingEvents = new ArrayList<PropertyChangeEvent>();
        for (PropertyChangeEvent event : events) {
            ConfigBean cb;
            ConfigBeanProxy cbp;
            oldValue = event.getOldValue();
            newValue = event.getNewValue();
            if (oldValue == null && newValue instanceof ConfigBeanProxy) {
                boolean doWait;
                cbp = (ConfigBeanProxy)newValue;
                cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap(cbp));
                if (!this.handleConfigBean(cb, doWait = this.amxIsRunning())) continue;
                newConfigBeans.add(cb);
                continue;
            }
            if (newValue == null && oldValue instanceof ConfigBeanProxy && this.amxIsRunning()) {
                cbp = (ConfigBeanProxy)oldValue;
                cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap(cbp));
                this.configBeanRemoved(cb);
                continue;
            }
            remainingEvents.add(event);
        }
        if (this.amxIsRunning()) {
            for (PropertyChangeEvent event : remainingEvents) {
                oldValue = event.getOldValue();
                newValue = event.getNewValue();
                Object source = event.getSource();
                String propertyName = event.getPropertyName();
                if (source instanceof ConfigBeanProxy) {
                    ConfigBeanProxy cbp = (ConfigBeanProxy)source;
                    ConfigBean cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap(cbp));
                    if (this.mRegistry.getObjectName(cb) == null) {
                        if (newConfigBeans.contains(cb) || !this.handleConfigBean(cb, false)) continue;
                        newConfigBeans.add(cb);
                        continue;
                    }
                    this.issueAttributeChange(cb, propertyName, oldValue, newValue, whenChanged);
                    continue;
                }
                AMXConfigLoader.debug("AMXConfigLoader.sortAndDispatch: WARNING: source is not a ConfigBean");
            }
        }
    }

    @Override
    public void transactionCommited(List<PropertyChangeEvent> changes) {
        this.sortAndDispatch(changes, System.currentTimeMillis());
    }

    @Override
    public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
    }

    public void handleNotification(Notification notif, Object handback) {
    }

    public void stop() {
        this.mTransactions.removeTransactionsListener(this);
        SingletonEnforcer.deregister(AMXConfigLoader.class, this);
    }

    boolean handleConfigBean(ConfigBean cb, boolean waitDone) {
        boolean processed = true;
        if (this.mRegistry.getObjectName(cb) == null) {
            PendingConfigBeanJob job = this.mPendingConfigBeans.add(cb, waitDone);
            if (job == null) {
                this.mLogger.log(Level.INFO, "NCLS-COM-00011", cb.getProxyType().getName());
                processed = false;
            } else if (waitDone) {
                try {
                    job.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return processed;
    }

    private ConfigBean getActualParent(ConfigBean configBean) {
        ConfigBean parent = AMXConfigLoader.asConfigBean(configBean.parent());
        if (parent == null && !configBean.getProxyType().getName().endsWith("Domain")) {
            throw new IllegalStateException("WARNING: parent is null for " + configBean.getProxyType().getName() + ",  see issue #10528");
        }
        return parent;
    }

    private ObjectName getActualParentObjectName(ConfigBean configBean) {
        ObjectName parentObjectName = null;
        ConfigBean parent = this.getActualParent(configBean);
        if (parent != null) {
            parentObjectName = this.mRegistry.getObjectName(parent);
        }
        return parentObjectName;
    }

    static ConfigBean asConfigBean(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof ConfigBean)) {
            throw new IllegalArgumentException("Not a ConfigBean: " + o.getClass().getName());
        }
        return (ConfigBean)o;
    }

    public synchronized ObjectName start() {
        this.mLogger.log(Level.INFO, "NCLS-COM-00012", this.mLoaderThread);
        if (this.mLoaderThread == null) {
            FeatureAvailability.getInstance().waitForFeature("AMXCoreReady", "AMXConfigLoader.start");
            this.mLoaderThread = new AMXConfigLoaderThread(this.mPendingConfigBeans);
            this.mLoaderThread.setDaemon(true);
            this.mLoaderThread.start();
            this.mPendingConfigBeans.swapTransactionListener(this);
            SingletonEnforcer.register(AMXConfigLoader.class, this);
            this.mLoaderThread.waitInitialQueue();
            ObjectName domainObjectName = ConfigBeanRegistry.getInstance().getObjectNameForProxy(this.getDomain());
            this.mLogger.log(Level.INFO, "amx.domain.config.registered", domainObjectName);
            FeatureAvailability.getInstance().registerFeature("AMXConfigReady", domainObjectName);
        }
        return null;
    }

    private synchronized boolean amxIsRunning() {
        return this.mLoaderThread != null;
    }

    private ObjectName registerConfigBeanAsMBean(ConfigBean cb) {
        ObjectName objectName = null;
        ConfigBean parentCB = this.getActualParent(cb);
        if (parentCB != null && this.mRegistry.getObjectName(parentCB) == null) {
            this.registerConfigBeanAsMBean(parentCB);
        }
        objectName = this._registerConfigBeanAsMBean(cb, parentCB);
        assert (objectName == null || this.mRegistry.getObjectName(cb) != null);
        return objectName;
    }

    private ObjectName _registerConfigBeanAsMBean(ConfigBean cb, ConfigBean parentCB) {
        Class cbClass = cb.getProxyType();
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName != null) {
            throw new IllegalArgumentException("ConfigBean " + cbClass.getName() + " already registered as " + objectName);
        }
        if (parentCB != null && this.mRegistry.getObjectName(parentCB) == null) {
            throw new IllegalArgumentException("ConfigBean parent " + parentCB.getProxyType().getName() + " must be registered first before child = " + cbClass.getName());
        }
        objectName = this.buildObjectName(cb);
        if ((objectName = this.createAndRegister(cb, objectName)) != null) {
            this.mLogger.fine("REGISTERED MBEAN: " + objectName);
        }
        return objectName;
    }

    private ObjectName createAndRegister(ConfigBean cb, ObjectName objectNameIn) {
        ObjectName objectName;
        ObjectName parentObjectName = this.getActualParentObjectName(cb);
        if (parentObjectName == null) {
            parentObjectName = AMXGlassfish.DEFAULT.domainRoot();
        }
        AMXConfigImpl impl = new AMXConfigImpl(parentObjectName, cb);
        try {
            ObjectInstance instance = this.mServer.registerMBean(impl, objectNameIn);
            objectName = instance.getObjectName();
            this.mRegistry.add(cb, objectName, impl);
        }
        catch (JMException e) {
            AMXConfigLoader.debug(ExceptionUtil.toString(e));
            objectName = null;
        }
        return objectName;
    }

    private String getType(ConfigBean cb) {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        return spt.getTypeString();
    }

    static String getKey(ConfigBean cb) {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        if (spt.isSingleton()) {
            return null;
        }
        String name = null;
        String nameHint = spt.getNameHint();
        if (nameHint == null) {
            name = "MISSING_NAME__KEY_MUST_BE_SPECIFIED_IN_INTERFACE";
        } else if (spt.nameHintIsElement()) {
            List<String> leaf = cb.leafElements(nameHint);
            if (leaf != null) {
                List<String> items = TypeCast.checkList(leaf, String.class);
                if (items.size() != 1) {
                    throw new IllegalArgumentException("Can't find sub-element of type " + nameHint + " in " + cb.getProxyType().getName());
                }
                name = items.get(0);
            }
        } else {
            name = cb.rawAttribute(nameHint);
        }
        return name;
    }

    public Domain getDomain() {
        return InjectedValues.getInstance().getHabitat().getService(Domain.class, new Annotation[0]);
    }

    private ObjectName buildObjectName(ConfigBean cb) {
        ConfigBean parent = this.getActualParent(cb);
        ObjectName parentObjectName = parent == null ? AMXGlassfish.DEFAULT.domainRoot() : this.mRegistry.getObjectName(parent);
        String type2 = this.getType(cb);
        String name = AMXConfigLoader.getKey(cb);
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        if (!(spt.isSingleton() || name != null && name.length() != 0)) {
            name = "MISSING_NAME-" + sCounter.getAndIncrement();
            this.mLogger.log(Level.WARNING, "NCLS-COM-00020", new Object[]{cb.getProxyType().getName(), name});
        }
        ObjectName objectName = ObjectNameBuilder.buildChildObjectName(this.mServer, parentObjectName, type2, AMXConfigLoader.quoteIfNeeded(name));
        return objectName;
    }

    private static String quoteIfNeeded(String name) {
        if (name != null && ILLEGAL_JMX_NAME_PATTERN.matcher(name).matches()) {
            return "\"" + name + "\"";
        }
        return name;
    }

    private final class AMXConfigLoaderThread
    extends Thread {
        private final PendingConfigBeans mPending;
        volatile boolean mQuit;
        private volatile CountDownLatch mInitalQueueLatch;

        AMXConfigLoaderThread(PendingConfigBeans pending) {
            super("AMXConfigLoader.AMXConfigLoaderThread");
            this.mQuit = false;
            this.mInitalQueueLatch = new CountDownLatch(1);
            this.mPending = pending;
        }

        void quit() {
            this.mQuit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectName registerOne(PendingConfigBeanJob job) {
            ConfigBean cb = job.getConfigBean();
            ObjectName objectName = AMXConfigLoader.this.mRegistry.getObjectName(cb);
            try {
                if (objectName == null) {
                    objectName = AMXConfigLoader.this.registerConfigBeanAsMBean(cb);
                }
            }
            catch (Throwable t) {
                AMXConfigLoader.this.mLogger.log(Level.WARNING, "NCLS-COM-00033", new Object[]{AMXConfigLoader.this.getType(cb), AMXConfigLoader.getKey(cb), t});
            }
            finally {
                job.releaseLatch();
            }
            return objectName;
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                AMXConfigLoader.this.mLogger.log(Level.SEVERE, "NCLS-COM-00034", t);
            }
        }

        public void waitInitialQueue() {
            CountDownLatch latch = this.mInitalQueueLatch;
            if (latch != null) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.mInitalQueueLatch = null;
            }
        }

        protected void doRun() throws Exception {
            PendingConfigBeanJob job = this.mPending.take();
            while (!this.mQuit && job != null) {
                this.registerOne(job);
                job = this.mPending.peek();
                if (job == null) continue;
                job = this.mPending.take();
            }
            this.mInitalQueueLatch.countDown();
            while (!this.mQuit) {
                job = this.mPending.take();
                this.registerOne(job);
            }
        }
    }
}

