/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.concurrent.admin;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.HashMap;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.concurrent.admin.CreateManagedExecutorServiceBase;
import org.glassfish.concurrent.admin.ManagedExecutorServiceManager;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.api.ResourceStatus;
import org.jvnet.hk2.annotations.Service;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE, CommandTarget.CONFIG})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="create-managed-executor-service")
@PerLookup
@I18n(value="create.managed.executor.service")
public class CreateManagedExecutorService
extends CreateManagedExecutorServiceBase
implements AdminCommand {
    @Param(name="maximumpoolsize", alias="maximumPoolSize", defaultValue="2147483647", optional=true)
    private Integer maximumpoolsize;
    @Param(name="taskqueuecapacity", alias="taskQueueCapacity", defaultValue="2147483647", optional=true)
    private Integer taskqueuecapacity;
    @Inject
    private Domain domain;
    @Inject
    private ManagedExecutorServiceManager managedExecutorServiceMgr;

    @Override
    protected void setAttributeList(HashMap attrList) {
        super.setAttributeList(attrList);
        attrList.put("maximum-pool-size", this.maximumpoolsize.toString());
        attrList.put("task-queue-capacity", this.taskqueuecapacity.toString());
    }

    @Override
    public void execute(AdminCommandContext context) {
        ResourceStatus rs;
        ActionReport report = context.getActionReport();
        HashMap attrList = new HashMap();
        this.setAttributeList(attrList);
        try {
            rs = this.managedExecutorServiceMgr.create(this.domain.getResources(), attrList, this.properties, this.target);
        }
        catch (Exception e) {
            report.setMessage(localStrings.getLocalString("create.managed.executor.service.failed", "Managed executor service {0} creation failed", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        if (rs.getMessage() != null) {
            report.setMessage(rs.getMessage());
        }
        if (rs.getStatus() == 1) {
            ec = ActionReport.ExitCode.FAILURE;
            if (rs.getException() != null) {
                report.setFailureCause(rs.getException());
            }
        }
        report.setActionExitCode(ec);
    }
}

