/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.MonitoringService;
import com.sun.enterprise.util.LocalStringManagerImpl;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AccessRequired;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandSecurity;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.flashlight.cli.MonitoringConfig;
import org.glassfish.flashlight.impl.client.AgentAttacher;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;

@Service(name="enable-monitoring")
@PerLookup
@I18n(value="enable.monitoring")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="enable-monitoring", description="enable-monitoring")})
public class EnableMonitoring
implements AdminCommand,
AdminCommandSecurity.Preauthorization {
    private MonitoringService ms;
    @Inject
    private Target targetService;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(optional=true)
    private String pid;
    @Param(optional=true)
    private String options;
    @Param(optional=true)
    private String modules;
    @Param(optional=true)
    private Boolean mbean;
    @Param(optional=true)
    private Boolean dtrace;
    private final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(EnableMonitoring.class);
    @AccessRequired.To(value={"update"})
    private Config targetConfig;
    static final String FLASHLIGHT_AGENT_PATH = "lib/monitor/flashlight-agent.jar";

    @Override
    public boolean preAuthorization(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            this.targetConfig = this.targetService.getConfig(this.target);
            if (this.targetConfig != null) {
                this.ms = this.targetConfig.getMonitoringService();
                return true;
            }
            this.fail(report, "unknown.target", "Could not find target {0}", this.target);
            return false;
        }
        catch (Exception e) {
            this.fail(report, "target.service.exception", "Encountered exception trying to locate the MonitoringService element in the target ({0}) configuration: {1}", this.target, e.getMessage());
            return false;
        }
    }

    private void fail(ActionReport report, String messageKey, String fallbackMessageText, Object ... args) {
        report.setMessage(this.localStrings.getLocalString(messageKey, fallbackMessageText, args));
        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
    }

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        int pidInt = -1;
        try {
            if (this.pid != null) {
                pidInt = Integer.parseInt(this.pid);
            }
        }
        catch (Exception e) {
            pidInt = -1;
        }
        if (this.options == null) {
            this.options = "";
        }
        if (!AgentAttacher.attachAgent(pidInt, this.options)) {
            ActionReport.MessagePart part = report.getTopMessagePart().addChild();
            part.setMessage(this.localStrings.getLocalString("attach.agent.exception", "Can't attach the agent to the JVM."));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (this.modules != null && this.modules.length() > 0) {
            String[] strArr = this.modules.split(":");
            String[] nvArr = null;
            for (String nv : strArr) {
                if (nv.length() <= 0) continue;
                nvArr = nv.split("=");
                if (nvArr.length > 1) {
                    if (!this.isValidString(nvArr[1])) continue;
                    this.setModuleMonitoringLevel(nvArr[0], nvArr[1], report);
                    continue;
                }
                if (!this.isValidString(nvArr[0])) continue;
                this.setModuleMonitoringLevel(nvArr[0], "HIGH", report);
            }
        }
        if (this.mbean != null) {
            MonitoringConfig.setMBeanEnabled(this.ms, this.mbean.toString(), report);
        }
        if (this.dtrace != null) {
            MonitoringConfig.setDTraceEnabled(this.ms, this.dtrace.toString(), report);
        }
        MonitoringConfig.setMonitoringEnabled(this.ms, "true", report);
    }

    private void setModuleMonitoringLevel(String moduleName, String level, ActionReport report) {
        ActionReport.MessagePart part = report.getTopMessagePart().addChild();
        if (!this.isValidString(moduleName)) {
            part.setMessage(this.localStrings.getLocalString("enable.monitoring.invalid", "Invalid module name {0}", moduleName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        if (!this.isValidString(level) || !this.isValidLevel(level)) {
            part.setMessage(this.localStrings.getLocalString("enable.monitoring.invalid", "Invalid level {0} for module name {1}", level, moduleName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        MonitoringConfig.setMonitoringLevel(this.ms, moduleName, level, report);
    }

    private boolean isValidString(String str) {
        return str != null && str.length() > 0;
    }

    private boolean isValidLevel(String level) {
        return level.equals("OFF") || level.equals("HIGH") || level.equals("LOW");
    }
}

