/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2;

import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http2.Http2BaseFilter;
import org.glassfish.grizzly.http2.Http2Connection;
import org.glassfish.grizzly.http2.draft14.Http2Connection14;

public enum DraftVersion {
    DRAFT_14(new SessionFactory(){

        @Override
        public Http2Connection create(Connection<?> grizzlyConnection, boolean isServer, Http2BaseFilter handlerFilter) {
            return new Http2Connection14(grizzlyConnection, isServer, handlerFilter);
        }
    }, "14", 100, 65535);

    private final String version;
    private final String clearTextId;
    private final String tlsId;
    private final String toString;
    private final int defaultMaxConcurrentStreams;
    private final int defaultStreamWindowSize;
    private final SessionFactory factory;

    private DraftVersion(SessionFactory factory, String version, int defaultMaxConcurrentStreams, int defaultStreamWindowSize) {
        this.factory = factory;
        this.version = version;
        this.defaultMaxConcurrentStreams = defaultMaxConcurrentStreams;
        this.defaultStreamWindowSize = defaultStreamWindowSize;
        this.clearTextId = "h2c-" + version;
        this.tlsId = "h2-" + version;
        this.toString = "[HTTP/2 draft #" + version + "]";
    }

    public Http2Connection newConnection(Connection<?> connection, boolean isServer, Http2BaseFilter handlerFilter) {
        return this.factory.create(connection, isServer, handlerFilter);
    }

    public String toString() {
        return this.toString;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClearTextId() {
        return this.clearTextId;
    }

    public String getTlsId() {
        return this.tlsId;
    }

    public int getDefaultMaxConcurrentStreams() {
        return this.defaultMaxConcurrentStreams;
    }

    public int getDefaultStreamWindowSize() {
        return this.defaultStreamWindowSize;
    }

    public boolean equals(String version) {
        return this.clearTextId.equalsIgnoreCase(version) || this.tlsId.equalsIgnoreCase(version);
    }

    public static DraftVersion fromString(String version) {
        if (DRAFT_14.equals(version)) {
            return DRAFT_14;
        }
        return null;
    }

    private static interface SessionFactory {
        public Http2Connection create(Connection<?> var1, boolean var2, Http2BaseFilter var3);
    }
}

